/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.templates.tags;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.el.ELResolver;
import org.apache.shindig.common.EasyMockTestCase;
import org.apache.shindig.common.PropertiesModule;
import org.apache.shindig.common.uri.Uri;
import org.apache.shindig.common.xml.DomUtil;
import org.apache.shindig.gadgets.Gadget;
import org.apache.shindig.gadgets.GadgetContext;
import org.apache.shindig.gadgets.GadgetException;
import org.apache.shindig.gadgets.features.FeatureRegistry;
import org.apache.shindig.gadgets.features.FeatureResource;
import org.apache.shindig.gadgets.parse.ParseModule;
import org.apache.shindig.gadgets.parse.nekohtml.NekoSimplifiedHtmlParser;
import org.apache.shindig.gadgets.rewrite.XPathWrapper;
import org.apache.shindig.gadgets.templates.TagRegistry;
import org.apache.shindig.gadgets.templates.TemplateContext;
import org.apache.shindig.gadgets.templates.TemplateProcessor;
import org.apache.shindig.gadgets.templates.tags.FlashTagHandler;
import org.apache.shindig.protocol.conversion.BeanJsonConverter;
import org.easymock.EasyMock;
import org.junit.Before;
import org.junit.Test;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class FlashTagHandlerTest
extends EasyMockTestCase {
    private MyTemplateProcessor processor;
    private DOMImplementation documentProvider;
    private FlashTagHandler handler;
    private FeatureRegistry featureRegistry;
    private GadgetContext gadgetContext = (GadgetContext)this.mock(GadgetContext.class);
    private Gadget gadget = (Gadget)this.mock(Gadget.class);
    private NekoSimplifiedHtmlParser parser;
    protected Document result;

    @Before
    public void setUp() throws Exception {
        this.processor = new MyTemplateProcessor();
        this.processor.context = new TemplateContext(this.gadget, Collections.emptyMap());
        Injector injector = Guice.createInjector((Module[])new Module[]{new ParseModule(), new PropertiesModule()});
        this.documentProvider = (DOMImplementation)injector.getInstance(DOMImplementation.class);
        this.parser = (NekoSimplifiedHtmlParser)injector.getInstance(NekoSimplifiedHtmlParser.class);
        this.featureRegistry = (FeatureRegistry)this.mock(FeatureRegistry.class, true);
        this.handler = new FlashTagHandler(new BeanJsonConverter(injector), this.featureRegistry, "http://example.org/ns", "9.0.115");
        this.result = this.parser.parseDom("");
        EasyMock.expect((Object)this.gadget.getContext()).andReturn((Object)this.gadgetContext).anyTimes();
    }

    private void expectFeatureLookup() throws GadgetException {
        ArrayList swfObjectResources = Lists.newArrayList();
        swfObjectResources.add(new SwfResource());
        EasyMock.expect((Object)this.featureRegistry.getFeatureResources((GadgetContext)EasyMock.isA(GadgetContext.class), (Collection)EasyMock.eq((Object)ImmutableSet.of((Object)"swfobject")), (List)EasyMock.isNull())).andReturn((Object)swfObjectResources);
    }

    private void expectSecurityToken() {
        EasyMock.expect((Object)this.gadgetContext.getParameter((String)EasyMock.eq((Object)"st"))).andReturn((Object)"12345");
    }

    @Test
    public void testBasicRender() throws Exception {
        Document document = this.parser.parseDom("<script type='text/os-template'><osx:Flash swf='http://www.example.org/test.swf'>Click Me</osx:Flash></script>");
        Element tag = (Element)DomUtil.getElementsByTagNameCaseInsensitive((Document)document, (Set)ImmutableSet.of((Object)"osx:flash")).get(0);
        this.expectSecurityToken();
        EasyMock.expect((Object)this.gadget.sanitizeOutput()).andReturn((Object)false);
        this.expectFeatureLookup();
        this.replay();
        this.handler.process(this.result.getDocumentElement().getFirstChild().getNextSibling(), tag, (TemplateProcessor)this.processor);
        XPathWrapper wrapper = new XPathWrapper(this.result);
        FlashTagHandlerTest.assertEquals((Object)"swfobject()", (Object)wrapper.getValue("/html/head/script[1]"));
        FlashTagHandlerTest.assertEquals((Object)"os_xFlash_alt_1", (Object)wrapper.getValue("/html/body/div/@id"));
        FlashTagHandlerTest.assertEquals((Object)"Click Me", (Object)wrapper.getValue("/html/body/div"));
        FlashTagHandlerTest.assertNull((Object)wrapper.getNode("/html/body/div/@onclick"));
        FlashTagHandlerTest.assertEquals((Object)wrapper.getValue("/html/body/script[1]"), (Object)"swfobject.embedSWF(\"http://www.example.org/test.swf\",\"os_xFlash_alt_1\",\"100px\",\"100px\",\"9.0.115\",null,null,{\"flashvars\":\"st=12345\"},{});");
        this.verify();
    }

    @Test
    public void testSanitizedRender() throws Exception {
        Document document = this.parser.parseDom("<script type='text/os-template'><osx:Flash swf='http://www.example.org/test.swf'>Click Me</osx:Flash></script>");
        Element tag = (Element)DomUtil.getElementsByTagNameCaseInsensitive((Document)document, (Set)ImmutableSet.of((Object)"osx:flash")).get(0);
        this.expectSecurityToken();
        EasyMock.expect((Object)this.gadget.sanitizeOutput()).andReturn((Object)true);
        this.expectFeatureLookup();
        this.replay();
        this.handler.process(this.result.getDocumentElement().getFirstChild().getNextSibling(), tag, (TemplateProcessor)this.processor);
        XPathWrapper wrapper = new XPathWrapper(this.result);
        FlashTagHandlerTest.assertEquals((Object)"swfobject()", (Object)wrapper.getValue("/html/head/script[1]"));
        FlashTagHandlerTest.assertEquals((Object)"os_xFlash_alt_1", (Object)wrapper.getValue("/html/body/div/@id"));
        FlashTagHandlerTest.assertEquals((Object)"Click Me", (Object)wrapper.getValue("/html/body/div"));
        FlashTagHandlerTest.assertNull((Object)wrapper.getNode("/html/body/div/@onclick"));
        FlashTagHandlerTest.assertEquals((Object)wrapper.getValue("/html/body/script[1]"), (Object)"swfobject.embedSWF(\"http://www.example.org/test.swf\",\"os_xFlash_alt_1\",\"100px\",\"100px\",\"9.0.115\",null,null,{\"swliveconnect\":false,\"flashvars\":\"st=12345\",\"allowscriptaccess\":\"never\",\"allownetworking\":\"internal\"},{});");
        this.verify();
    }

    @Test
    public void testSanitizedRenderClickToPlay() throws Exception {
        Document document = this.parser.parseDom("<script type='text/os-template'><osx:flash swf='http://www.example.org/test.swf' play='onclick'>Click Me</osx:flash></script>");
        Element tag = (Element)DomUtil.getElementsByTagNameCaseInsensitive((Document)document, (Set)ImmutableSet.of((Object)"osx:flash")).get(0);
        this.expectSecurityToken();
        EasyMock.expect((Object)this.gadget.sanitizeOutput()).andReturn((Object)true);
        this.expectFeatureLookup();
        this.replay();
        this.handler.process(this.result.getDocumentElement().getFirstChild().getNextSibling(), tag, (TemplateProcessor)this.processor);
        XPathWrapper wrapper = new XPathWrapper(this.result);
        FlashTagHandlerTest.assertEquals((Object)"swfobject()", (Object)wrapper.getValue("/html/head/script[1]"));
        FlashTagHandlerTest.assertEquals((Object)"os_xFlash_alt_1", (Object)wrapper.getValue("/html/body/div/@id"));
        FlashTagHandlerTest.assertEquals((Object)"Click Me", (Object)wrapper.getValue("/html/body/div"));
        FlashTagHandlerTest.assertEquals((Object)"os_xFlash_alt_1()", (Object)wrapper.getValue("/html/body/div/@onclick"));
        FlashTagHandlerTest.assertEquals((Object)wrapper.getValue("/html/body/script[1]"), (Object)"function os_xFlash_alt_1(){ swfobject.embedSWF(\"http://www.example.org/test.swf\",\"os_xFlash_alt_1\",\"100px\",\"100px\",\"9.0.115\",null,null,{\"swliveconnect\":false,\"flashvars\":\"st=12345\",\"allowscriptaccess\":\"never\",\"allownetworking\":\"internal\"},{}); }");
        this.verify();
    }

    @Test
    public void testConfigCreation() throws Exception {
        Document doc = this.documentProvider.createDocument(null, null, null);
        Element tag = doc.createElement("test");
        tag.setAttribute("id", "myflash");
        tag.setAttribute("class", "stylish");
        tag.setAttribute("swf", "http://www.example.org/x.swf");
        tag.setAttribute("width", "100px");
        tag.setAttribute("height", "200px");
        tag.setAttribute("name", "myflashname");
        tag.setAttribute("play", "onclick");
        tag.setAttribute("menu", "true");
        tag.setAttribute("scale", "exactfit");
        tag.setAttribute("wmode", "transparent");
        tag.setAttribute("devicefont", "true");
        tag.setAttribute("swliveconnect", "true");
        tag.setAttribute("allowscriptaccess", "samedomain");
        tag.setAttribute("quality", "autohigh");
        tag.setAttribute("salign", "tl");
        tag.setAttribute("bgcolor", "#77ff77");
        tag.setAttribute("allowfullscreen", "true");
        tag.setAttribute("allownetworking", "none");
        tag.setAttribute("flashvars", "a=b&c=d");
        FlashTagHandler.SwfObjectConfig config = this.handler.getSwfConfig(tag, (TemplateProcessor)this.processor);
        FlashTagHandlerTest.assertEquals((Object)"myflash", (Object)config.id);
        FlashTagHandlerTest.assertEquals((Object)"stylish", (Object)config.clazz);
        FlashTagHandlerTest.assertEquals((Object)config.swf, (Object)Uri.parse((String)"http://www.example.org/x.swf"));
        FlashTagHandlerTest.assertEquals((Object)"100px", (Object)config.width);
        FlashTagHandlerTest.assertEquals((Object)"200px", (Object)config.height);
        FlashTagHandlerTest.assertEquals((Object)"myflashname", (Object)config.name);
        FlashTagHandlerTest.assertEquals((Object)FlashTagHandler.SwfObjectConfig.Play.onclick, (Object)config.play);
        FlashTagHandlerTest.assertEquals((Object)Boolean.TRUE, (Object)config.menu);
        FlashTagHandlerTest.assertEquals((Object)FlashTagHandler.SwfObjectConfig.Scale.exactfit, (Object)config.scale);
        FlashTagHandlerTest.assertEquals((Object)FlashTagHandler.SwfObjectConfig.WMode.transparent, (Object)config.wmode);
        FlashTagHandlerTest.assertEquals((Object)Boolean.TRUE, (Object)config.devicefont);
        FlashTagHandlerTest.assertEquals((Object)Boolean.TRUE, (Object)config.swliveconnect);
        FlashTagHandlerTest.assertEquals((Object)FlashTagHandler.SwfObjectConfig.ScriptAccess.samedomain, (Object)config.allowscriptaccess);
        FlashTagHandlerTest.assertNull((Object)config.loop);
        FlashTagHandlerTest.assertEquals((Object)FlashTagHandler.SwfObjectConfig.Quality.autohigh, (Object)config.quality);
        FlashTagHandlerTest.assertEquals((Object)FlashTagHandler.SwfObjectConfig.SAlign.tl, (Object)config.salign);
        FlashTagHandlerTest.assertEquals((Object)"#77ff77", (Object)config.bgcolor);
        FlashTagHandlerTest.assertEquals((Object)Boolean.TRUE, (Object)config.allowfullscreen);
        FlashTagHandlerTest.assertEquals((Object)FlashTagHandler.SwfObjectConfig.NetworkAccess.none, (Object)config.allownetworking);
        FlashTagHandlerTest.assertEquals((Object)"a=b&c=d", (Object)config.flashvars);
    }

    @Test
    public void testConfigBindingFailure() throws Exception {
        Document document = this.parser.parseDom("<script type='text/os-template'><osx:flash swf='http://www.example.org/test.swf' play='junk'>Click Me</osx:flash></script>");
        Element tag = (Element)DomUtil.getElementsByTagNameCaseInsensitive((Document)document, (Set)ImmutableSet.of((Object)"osx:flash")).get(0);
        this.handler.process(this.result.getDocumentElement().getFirstChild().getNextSibling(), tag, (TemplateProcessor)this.processor);
        XPathWrapper wrapper = new XPathWrapper(this.result);
        FlashTagHandlerTest.assertTrue((boolean)wrapper.getValue("/html/body/span").startsWith("Failed to process os:Flash tag"));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MyTemplateProcessor
    implements TemplateProcessor {
        public TemplateContext context;

        private MyTemplateProcessor() {
        }

        public DocumentFragment processTemplate(Element template, TemplateContext templateContext, ELResolver globals, TagRegistry registry) {
            throw new UnsupportedOperationException();
        }

        public TemplateContext getTemplateContext() {
            return this.context;
        }

        public void processRepeat(Node result, Element element, Iterable<?> dataList, Runnable onEachLoop) {
            Iterator<?> iterator = dataList.iterator();
            while (iterator.hasNext()) {
                iterator.next();
                onEachLoop.run();
            }
        }

        public <T> T evaluate(String expression, Class<T> type, T defaultValue) {
            return type.cast(expression);
        }

        public void processChildNodes(Node result, Node source) {
            NodeList childNodes = source.getChildNodes();
            for (int i = 0; i < childNodes.getLength(); ++i) {
                Node child = childNodes.item(0).cloneNode(true);
                result.getOwnerDocument().adoptNode(child);
                result.appendChild(child);
            }
        }
    }

    private static class SwfResource
    extends FeatureResource.Default {
        private SwfResource() {
        }

        public String getContent() {
            return "swfobject()";
        }

        public String getDebugContent() {
            return "swfobject";
        }
    }
}

