/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.rewrite;

import javax.annotation.Nullable;
import org.apache.shindig.gadgets.http.HttpRequest;
import org.apache.shindig.gadgets.http.HttpResponse;
import org.apache.shindig.gadgets.http.HttpResponseBuilder;
import org.apache.shindig.gadgets.uri.UriCommon;

public final class RewriterUtils {
    private RewriterUtils() {
    }

    public static boolean isHtml(HttpRequest request, HttpResponse original) {
        String mimeType = RewriterUtils.getMimeType(request, original);
        return mimeType != null && mimeType.contains("html");
    }

    public static boolean isHtml(HttpRequest request, HttpResponseBuilder original) {
        String mimeType = RewriterUtils.getMimeType(request, original);
        return mimeType != null && mimeType.contains("html") && RewriterUtils.maybeAcceptHtml(request.getParam(UriCommon.Param.HTML_TAG_CONTEXT.getKey()));
    }

    public static boolean maybeAcceptHtml(@Nullable String htmlTagName) {
        return !"script".equalsIgnoreCase(htmlTagName);
    }

    public static boolean isCss(HttpRequest request, HttpResponse original) {
        String mimeType = RewriterUtils.getMimeType(request, original);
        return mimeType != null && mimeType.contains("css");
    }

    public static boolean isCss(HttpRequest request, HttpResponseBuilder original) {
        String mimeType = RewriterUtils.getMimeType(request, original);
        return mimeType != null && mimeType.contains("css");
    }

    public static boolean isJavascript(HttpRequest request, HttpResponse original) {
        String mimeType = RewriterUtils.getMimeType(request, original);
        return mimeType != null && mimeType.contains("javascript");
    }

    public static boolean isJavascript(HttpRequest request, HttpResponseBuilder original) {
        String mimeType = RewriterUtils.getMimeType(request, original);
        return mimeType != null && mimeType.contains("javascript");
    }

    public static String getMimeType(HttpRequest request, HttpResponse original) {
        String mimeType = request.getRewriteMimeType();
        if (mimeType == null) {
            mimeType = original.getHeader("Content-Type");
        }
        return mimeType != null ? mimeType.toLowerCase() : null;
    }

    public static String getMimeType(HttpRequest request, HttpResponseBuilder original) {
        String mimeType = request.getRewriteMimeType();
        if (mimeType == null) {
            mimeType = original.getHeader("Content-Type");
        }
        return mimeType != null ? mimeType.toLowerCase() : null;
    }
}

