/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.rewrite;

import com.google.common.base.Objects;
import java.util.List;
import org.apache.shindig.common.xml.DomUtil;
import org.apache.shindig.gadgets.Gadget;
import org.apache.shindig.gadgets.rewrite.DomWalker;
import org.apache.shindig.gadgets.rewrite.RewritingException;
import org.w3c.dom.Attr;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StyleAdjacencyVisitor
implements DomWalker.Visitor {
    @Override
    public DomWalker.Visitor.VisitStatus visit(Gadget gadget, Node node) throws RewritingException {
        if (node.getNodeType() == 1 && ("style".equalsIgnoreCase(node.getNodeName()) || "link".equalsIgnoreCase(node.getNodeName()) && ("stylesheet".equalsIgnoreCase(this.getAttrib(node, "rel")) || "text/css".equalsIgnoreCase(this.getAttrib(node, "type"))))) {
            return DomWalker.Visitor.VisitStatus.RESERVE_TREE;
        }
        return DomWalker.Visitor.VisitStatus.BYPASS;
    }

    @Override
    public boolean revisit(Gadget gadget, List<Node> nodes) throws RewritingException {
        Node head = DomUtil.getFirstNamedChildNode((Node)nodes.get(0).getOwnerDocument().getDocumentElement(), (String)"head");
        if (head == null) {
            return false;
        }
        for (Node n : nodes) {
            n.getParentNode().removeChild(n);
        }
        if (head.getFirstChild() == null) {
            for (Node n : nodes) {
                head.appendChild(n);
            }
        } else {
            Node firstChild = head.getFirstChild();
            for (Node n : nodes) {
                head.insertBefore(n, firstChild);
            }
        }
        return true;
    }

    private String getAttrib(Node node, String key) {
        String value = null;
        NamedNodeMap attribs = node.getAttributes();
        for (int i = 0; i < attribs.getLength(); ++i) {
            Attr attr = (Attr)attribs.item(i);
            if (!key.equalsIgnoreCase(attr.getName())) continue;
            value = attr.getValue();
            break;
        }
        return (String)Objects.firstNonNull(value, (Object)"");
    }
}

