/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.servlet;

import com.google.inject.Inject;
import java.io.IOException;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.shindig.common.servlet.HttpUtil;
import org.apache.shindig.common.servlet.InjectedServlet;
import org.apache.shindig.common.uri.UriBuilder;
import org.apache.shindig.gadgets.GadgetContext;
import org.apache.shindig.gadgets.render.Renderer;
import org.apache.shindig.gadgets.render.RenderingResults;
import org.apache.shindig.gadgets.servlet.HttpGadgetContext;
import org.apache.shindig.gadgets.uri.IframeUriManager;
import org.apache.shindig.gadgets.uri.UriCommon;
import org.apache.shindig.gadgets.uri.UriStatus;

public class GadgetRenderingServlet
extends InjectedServlet {
    private static final long serialVersionUID = -5634040113214794888L;
    static final int DEFAULT_CACHE_TTL = 300;
    private static final Logger LOG = Logger.getLogger(GadgetRenderingServlet.class.getName());
    private transient Renderer renderer;
    private transient IframeUriManager iframeUriManager;

    @Inject
    public void setRenderer(Renderer renderer) {
        this.checkInitialized();
        this.renderer = renderer;
    }

    @Inject
    public void setIframeUriManager(IframeUriManager iframeUriManager) {
        this.checkInitialized();
        this.iframeUriManager = iframeUriManager;
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        UriStatus urlStatus = this.getUrlStatus(req);
        if (req.getHeader("If-Modified-Since") != null && !"1".equals(req.getParameter("nocache")) && urlStatus == UriStatus.VALID_VERSIONED) {
            resp.setStatus(304);
            return;
        }
        this.render(req, resp, urlStatus);
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        this.render(req, resp, this.getUrlStatus(req));
    }

    private void render(HttpServletRequest req, HttpServletResponse resp, UriStatus urlstatus) throws IOException {
        if (req.getHeader("X-shindig-dos") != null) {
            resp.sendError(403);
            return;
        }
        resp.setContentType("text/html");
        resp.setCharacterEncoding("UTF-8");
        HttpGadgetContext context = new HttpGadgetContext(req);
        RenderingResults results = this.renderer.render(context);
        this.postGadgetRendering(new PostGadgetRenderingParams(req, resp, urlstatus, context, results));
    }

    protected void postGadgetRendering(PostGadgetRenderingParams params) throws IOException {
        switch (params.getResults().getStatus()) {
            case OK: {
                this.onOkRenderingResultsStatus(params);
                break;
            }
            case ERROR: {
                this.onErrorRenderingResultsStatus(params);
                break;
            }
            case MUST_REDIRECT: {
                this.onMustRedirectRenderingResultsStatus(params);
            }
        }
    }

    protected void onOkRenderingResultsStatus(PostGadgetRenderingParams params) throws IOException {
        UriStatus urlStatus = params.getUrlStatus();
        HttpServletResponse resp = params.getResponse();
        if (params.getContext().getIgnoreCache() || urlStatus == UriStatus.INVALID_VERSION) {
            HttpUtil.setCachingHeaders((HttpServletResponse)resp, (int)0);
        } else if (urlStatus == UriStatus.VALID_VERSIONED) {
            HttpUtil.setCachingHeaders((HttpServletResponse)resp, (boolean)true);
        } else {
            int ttl = 300;
            String ttlStr = params.getRequest().getParameter(UriCommon.Param.REFRESH.getKey());
            if (!StringUtils.isEmpty((String)ttlStr)) {
                try {
                    ttl = Integer.parseInt(ttlStr);
                }
                catch (NumberFormatException e) {
                    LOG.info("Bad TTL value '" + ttlStr + "' was ignored");
                }
            }
            HttpUtil.setCachingHeaders((HttpServletResponse)resp, (int)ttl, (boolean)true);
        }
        resp.getWriter().print(params.getResults().getContent());
    }

    protected void onErrorRenderingResultsStatus(PostGadgetRenderingParams params) throws IOException {
        HttpServletResponse resp = params.getResponse();
        resp.setStatus(params.getResults().getHttpStatusCode());
        LOG.info("Error rendering gadget: " + params.getResults().getErrorMessage());
        resp.getWriter().print("An error occurred while rendering this gadget.");
    }

    protected void onMustRedirectRenderingResultsStatus(PostGadgetRenderingParams params) throws IOException {
        params.getResponse().sendRedirect(params.getResults().getRedirect().toString());
    }

    private UriStatus getUrlStatus(HttpServletRequest req) {
        return this.iframeUriManager.validateRenderingUri(new UriBuilder(req).toUri());
    }

    protected static class PostGadgetRenderingParams {
        private HttpServletRequest req;
        private HttpServletResponse resp;
        private UriStatus urlStatus;
        private GadgetContext context;
        private RenderingResults results;

        public PostGadgetRenderingParams(HttpServletRequest req, HttpServletResponse resp, UriStatus urlStatus, GadgetContext context, RenderingResults results) {
            this.req = req;
            this.resp = resp;
            this.urlStatus = urlStatus;
            this.context = context;
            this.results = results;
        }

        public HttpServletRequest getRequest() {
            return this.req;
        }

        public HttpServletResponse getResponse() {
            return this.resp;
        }

        public UriStatus getUrlStatus() {
            return this.urlStatus;
        }

        public GadgetContext getContext() {
            return this.context;
        }

        public RenderingResults getResults() {
            return this.results;
        }
    }
}

