/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.social.dataservice.integration;

import java.util.List;
import java.util.Map;
import org.apache.shindig.social.core.model.ActivityImpl;
import org.apache.shindig.social.dataservice.integration.AbstractLargeRestfulTests;
import org.apache.shindig.social.opensocial.model.Activity;
import org.apache.shindig.social.opensocial.util.XSDValidator;
import org.custommonkey.xmlunit.XMLUnit;
import org.junit.Before;
import org.junit.Test;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RestfulXmlActivityTest
extends AbstractLargeRestfulTests {
    private Activity johnsActivity;

    @Before
    public void restfulXmlActivityTestBefore() throws Exception {
        this.johnsActivity = new ActivityImpl("1", "john.doe");
        this.johnsActivity.setTitle("yellow");
        this.johnsActivity.setBody("what a color!");
    }

    @Test
    public void testGetActivityJson() throws Exception {
        String resp = this.getResponse("/activities/john.doe/@self/@app/1", "GET", "xml", "application/xml");
        XSDValidator.validateOpenSocial(resp);
        NodeList result = this.xp.getMatchingNodes("/:response/:activity", XMLUnit.buildTestDocument((String)resp));
        RestfulXmlActivityTest.assertEquals((long)1L, (long)result.getLength());
        Node n = result.item(0);
        Map<String, List<String>> v = this.childNodesToMap(n);
        RestfulXmlActivityTest.assertEquals((long)4L, (long)v.size());
        this.assertActivitiesEqual(this.johnsActivity, v);
    }

    @Test
    public void testGetActivitiesJson() throws Exception {
        String resp = this.getResponse("/activities/john.doe/@self", "GET", "xml", "application/xml");
        XSDValidator.validateOpenSocial(resp);
        RestfulXmlActivityTest.assertEquals((Object)"0", (Object)this.xp.evaluate("/:response/:startIndex", XMLUnit.buildTestDocument((String)resp)));
        RestfulXmlActivityTest.assertEquals((Object)"1", (Object)this.xp.evaluate("/:response/:totalResults", XMLUnit.buildTestDocument((String)resp)));
        NodeList nl = this.xp.getMatchingNodes("/:response/:entry/:activity", XMLUnit.buildTestDocument((String)resp));
        RestfulXmlActivityTest.assertEquals((long)1L, (long)nl.getLength());
        this.assertActivitiesEqual(this.johnsActivity, this.childNodesToMap(nl.item(0)));
    }

    @Test
    public void testGetFriendsActivitiesJson() throws Exception {
        String resp = this.getResponse("/activities/john.doe/@friends", "GET", "xml", "application/xml");
        XSDValidator.validateOpenSocial(resp);
        RestfulXmlActivityTest.assertEquals((Object)"0", (Object)this.xp.evaluate("/:response/:startIndex", XMLUnit.buildTestDocument((String)resp)));
        RestfulXmlActivityTest.assertEquals((Object)"2", (Object)this.xp.evaluate("/:response/:totalResults", XMLUnit.buildTestDocument((String)resp)));
        NodeList nl = this.xp.getMatchingNodes("/:response/:entry", XMLUnit.buildTestDocument((String)resp));
        RestfulXmlActivityTest.assertEquals((long)2L, (long)nl.getLength());
    }

    private void assertActivitiesEqual(Activity activity, Map<String, List<String>> result) {
        RestfulXmlActivityTest.assertEquals((Object)activity.getId(), (Object)result.get("id").get(0));
        RestfulXmlActivityTest.assertEquals((Object)activity.getUserId(), (Object)result.get("userId").get(0));
        RestfulXmlActivityTest.assertEquals((Object)activity.getTitle(), (Object)result.get("title").get(0));
        RestfulXmlActivityTest.assertEquals((Object)activity.getBody(), (Object)result.get("body").get(0));
    }

    @Test
    public void testCreateActivity() throws Exception {
        String postData = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<activity><body>and dad.</body><title>hi mom!</title></activity>";
        String createResponse = this.getResponse("/activities/john.doe/@self", "POST", postData, "xml", "application/xml");
        XSDValidator.validateOpenSocial(createResponse);
        String resp = this.getResponse("/activities/john.doe/@self", "GET", "xml", "application/xml");
        XSDValidator.validateOpenSocial(resp);
        RestfulXmlActivityTest.assertEquals((Object)"0", (Object)this.xp.evaluate("/:response/:startIndex", XMLUnit.buildTestDocument((String)resp)));
        RestfulXmlActivityTest.assertEquals((Object)"2", (Object)this.xp.evaluate("/:response/:totalResults", XMLUnit.buildTestDocument((String)resp)));
        NodeList nl = this.xp.getMatchingNodes("/:response/:entry/:activity", XMLUnit.buildTestDocument((String)resp));
        RestfulXmlActivityTest.assertEquals((long)2L, (long)nl.getLength());
        Map<String, List<String>> v = this.childNodesToMap(nl.item(0));
        if (v.containsKey("id")) {
            v = this.childNodesToMap(nl.item(1));
        }
        RestfulXmlActivityTest.assertEquals((Object)"hi mom!", (Object)v.get("title").get(0));
        RestfulXmlActivityTest.assertEquals((Object)"and dad.", (Object)v.get("body").get(0));
    }
}

