/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.social.opensocial.service;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.Reader;
import java.io.StringReader;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Future;
import org.apache.shindig.auth.SecurityToken;
import org.apache.shindig.common.EasyMockTestCase;
import org.apache.shindig.common.testing.FakeGadgetToken;
import org.apache.shindig.common.util.ImmediateFuture;
import org.apache.shindig.config.ContainerConfig;
import org.apache.shindig.config.JsonContainerConfig;
import org.apache.shindig.expressions.Expressions;
import org.apache.shindig.protocol.DefaultHandlerRegistry;
import org.apache.shindig.protocol.HandlerExecutionListener;
import org.apache.shindig.protocol.HandlerRegistry;
import org.apache.shindig.protocol.ProtocolException;
import org.apache.shindig.protocol.RestHandler;
import org.apache.shindig.protocol.RestfulCollection;
import org.apache.shindig.protocol.conversion.BeanConverter;
import org.apache.shindig.protocol.conversion.BeanJsonConverter;
import org.apache.shindig.social.core.model.ActivityImpl;
import org.apache.shindig.social.opensocial.model.Activity;
import org.apache.shindig.social.opensocial.service.ActivityHandler;
import org.apache.shindig.social.opensocial.spi.ActivityService;
import org.apache.shindig.social.opensocial.spi.CollectionOptions;
import org.apache.shindig.social.opensocial.spi.GroupId;
import org.apache.shindig.social.opensocial.spi.UserId;
import org.easymock.EasyMock;
import org.json.JSONObject;
import org.junit.Before;
import org.junit.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ActivityHandlerTest
extends EasyMockTestCase {
    private BeanJsonConverter converter;
    private ActivityService activityService;
    private ActivityHandler handler;
    private FakeGadgetToken token;
    private static final Set<UserId> JOHN_DOE = ImmutableSet.of((Object)new UserId(UserId.Type.userId, "john.doe"));
    protected HandlerRegistry registry;
    protected ContainerConfig containerConfig;

    @Before
    public void setUp() throws Exception {
        this.token = new FakeGadgetToken();
        this.token.setAppId("appId");
        this.converter = (BeanJsonConverter)this.mock(BeanJsonConverter.class);
        this.activityService = (ActivityService)this.mock(ActivityService.class);
        JSONObject config = new JSONObject("{default:{'gadgets.features':{opensocial:{supportedFields: {activity: ['id', 'title']}}}}}");
        this.containerConfig = new JsonContainerConfig(config, Expressions.forTesting());
        this.handler = new ActivityHandler(this.activityService, this.containerConfig);
        this.registry = new DefaultHandlerRegistry(null, this.converter, (HandlerExecutionListener)new HandlerExecutionListener.NoOpHandler());
        this.registry.addHandlers((Set)ImmutableSet.of((Object)this.handler));
    }

    private void assertHandleGetForGroup(GroupId.Type group) throws Exception {
        String path = "/activities/john.doe/@" + group.toString();
        RestHandler operation = this.registry.getRestHandler(path, "GET");
        ImmutableList activityList = ImmutableList.of();
        RestfulCollection data = new RestfulCollection((List)activityList);
        EasyMock.expect((Object)this.activityService.getActivities((Set)EasyMock.eq(JOHN_DOE), (GroupId)EasyMock.eq((Object)new GroupId(group, null)), (String)EasyMock.isNull(), (Set)EasyMock.eq((Object)ImmutableSet.of()), (CollectionOptions)EasyMock.isA(CollectionOptions.class), (SecurityToken)EasyMock.eq((Object)this.token))).andReturn((Object)ImmediateFuture.newInstance((Object)data));
        this.replay();
        ActivityHandlerTest.assertEquals((Object)data, operation.execute((Map)Maps.newHashMap(), null, (SecurityToken)this.token, (BeanConverter)this.converter).get());
        this.verify();
        this.reset();
    }

    @Test
    public void testHandleGetAll() throws Exception {
        this.assertHandleGetForGroup(GroupId.Type.all);
    }

    @Test
    public void testHandleGetFriends() throws Exception {
        this.assertHandleGetForGroup(GroupId.Type.friends);
    }

    @Test
    public void testHandleGetSelf() throws Exception {
        this.assertHandleGetForGroup(GroupId.Type.self);
    }

    @Test
    public void testHandleGetPlural() throws Exception {
        String path = "/activities/john.doe,jane.doe/@self/@app";
        RestHandler operation = this.registry.getRestHandler(path, "GET");
        ImmutableList activities = ImmutableList.of();
        RestfulCollection data = new RestfulCollection((List)activities);
        LinkedHashSet userIdSet = Sets.newLinkedHashSet(JOHN_DOE);
        userIdSet.add(new UserId(UserId.Type.userId, "jane.doe"));
        EasyMock.expect((Object)this.activityService.getActivities((Set)EasyMock.eq((Object)userIdSet), (GroupId)EasyMock.eq((Object)new GroupId(GroupId.Type.self, null)), (String)EasyMock.eq((Object)"appId"), (Set)EasyMock.eq((Object)ImmutableSet.of()), (CollectionOptions)EasyMock.isA(CollectionOptions.class), (SecurityToken)EasyMock.eq((Object)this.token))).andReturn((Object)ImmediateFuture.newInstance((Object)data));
        this.replay();
        ActivityHandlerTest.assertEquals((Object)data, operation.execute((Map)Maps.newHashMap(), null, (SecurityToken)this.token, (BeanConverter)this.converter).get());
        this.verify();
        this.reset();
    }

    @Test
    public void testHandleGetActivityById() throws Exception {
        String path = "/activities/john.doe/@friends/@app/1";
        RestHandler operation = this.registry.getRestHandler(path, "GET");
        ActivityImpl activity = new ActivityImpl();
        EasyMock.expect((Object)this.activityService.getActivity((UserId)EasyMock.eq((Object)JOHN_DOE.iterator().next()), (GroupId)EasyMock.eq((Object)new GroupId(GroupId.Type.friends, null)), (String)EasyMock.eq((Object)"appId"), (Set)EasyMock.eq((Object)ImmutableSet.of()), (String)EasyMock.eq((Object)"1"), (SecurityToken)EasyMock.eq((Object)this.token))).andReturn((Object)ImmediateFuture.newInstance((Object)activity));
        this.replay();
        ActivityHandlerTest.assertEquals((Object)activity, operation.execute((Map)Maps.newHashMap(), null, (SecurityToken)this.token, (BeanConverter)this.converter).get());
        this.verify();
        this.reset();
    }

    private Future<?> setupBodyRequest(String method) throws ProtocolException {
        String jsonActivity = "{title: hi mom!, etc etc}";
        String path = "/activities/john.doe/@self/@app";
        RestHandler operation = this.registry.getRestHandler(path, method);
        ActivityImpl activity = new ActivityImpl();
        EasyMock.expect((Object)this.converter.convertToObject((String)EasyMock.eq((Object)jsonActivity), (Class)EasyMock.eq(Activity.class))).andReturn((Object)activity);
        EasyMock.expect((Object)this.activityService.createActivity((UserId)EasyMock.eq((Object)JOHN_DOE.iterator().next()), (GroupId)EasyMock.eq((Object)new GroupId(GroupId.Type.self, null)), (String)EasyMock.eq((Object)"appId"), (Set)EasyMock.eq((Object)ImmutableSet.of()), (Activity)EasyMock.eq((Object)activity), (SecurityToken)EasyMock.eq((Object)this.token))).andReturn((Object)ImmediateFuture.newInstance((Object)null));
        this.replay();
        return operation.execute((Map)Maps.newHashMap(), (Reader)new StringReader(jsonActivity), (SecurityToken)this.token, (BeanConverter)this.converter);
    }

    @Test
    public void testHandlePost() throws Exception {
        Future<?> future = this.setupBodyRequest("POST");
        ActivityHandlerTest.assertNull(future.get());
        this.verify();
        this.reset();
    }

    @Test
    public void testHandlePut() throws Exception {
        Future<?> future = this.setupBodyRequest("PUT");
        ActivityHandlerTest.assertNull(future.get());
        this.verify();
        this.reset();
    }

    @Test
    public void testHandleDelete() throws Exception {
        String path = "/activities/john.doe/@self/@app/1";
        RestHandler operation = this.registry.getRestHandler(path, "DELETE");
        EasyMock.expect((Object)this.activityService.deleteActivities((UserId)EasyMock.eq((Object)JOHN_DOE.iterator().next()), (GroupId)EasyMock.eq((Object)new GroupId(GroupId.Type.self, null)), (String)EasyMock.eq((Object)"appId"), (Set)EasyMock.eq((Object)ImmutableSet.of((Object)"1")), (SecurityToken)EasyMock.eq((Object)this.token))).andReturn((Object)ImmediateFuture.newInstance((Object)null));
        this.replay();
        ActivityHandlerTest.assertNull(operation.execute((Map)Maps.newHashMap(), null, (SecurityToken)this.token, (BeanConverter)this.converter).get());
        this.verify();
        this.reset();
    }

    @Test
    public void testHandleGetSuportedFields() throws Exception {
        String path = "/activities/@supportedFields";
        RestHandler operation = this.registry.getRestHandler(path, "GET");
        this.replay();
        List received = (List)operation.execute((Map)Maps.newHashMap(), null, (SecurityToken)this.token, (BeanConverter)this.converter).get();
        ActivityHandlerTest.assertEquals((long)2L, (long)received.size());
        ActivityHandlerTest.assertEquals((Object)"id", (Object)received.get(0).toString());
        ActivityHandlerTest.assertEquals((Object)"title", (Object)received.get(1).toString());
        this.verify();
    }
}

