/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.social.opensocial.service;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.shindig.auth.SecurityToken;
import org.apache.shindig.common.EasyMockTestCase;
import org.apache.shindig.common.testing.FakeGadgetToken;
import org.apache.shindig.config.ContainerConfig;
import org.apache.shindig.config.JsonContainerConfig;
import org.apache.shindig.expressions.Expressions;
import org.apache.shindig.protocol.DefaultHandlerRegistry;
import org.apache.shindig.protocol.HandlerExecutionListener;
import org.apache.shindig.protocol.HandlerRegistry;
import org.apache.shindig.protocol.RestHandler;
import org.apache.shindig.protocol.conversion.BeanConverter;
import org.apache.shindig.protocol.conversion.BeanJsonConverter;
import org.apache.shindig.social.opensocial.service.MediaItemHandler;
import org.apache.shindig.social.opensocial.spi.MediaItemService;
import org.json.JSONObject;
import org.junit.Before;
import org.junit.Test;

public class MediaItemHandlerTest
extends EasyMockTestCase {
    private MediaItemService mediaService;
    private MediaItemHandler handler;
    private ContainerConfig containerConfig;
    private FakeGadgetToken token;
    protected HandlerRegistry registry;
    private BeanJsonConverter converter;

    @Before
    public void setUp() throws Exception {
        this.token = new FakeGadgetToken();
        this.converter = (BeanJsonConverter)this.mock(BeanJsonConverter.class);
        this.mediaService = (MediaItemService)this.mock(MediaItemService.class);
        JSONObject config = new JSONObject("{default:{'gadgets.features':{opensocial:{supportedFields: {mediaItem: ['id', 'language', 'title']}}}}}");
        this.containerConfig = new JsonContainerConfig(config, Expressions.forTesting());
        this.handler = new MediaItemHandler(this.mediaService, this.containerConfig);
        this.registry = new DefaultHandlerRegistry(null, this.converter, (HandlerExecutionListener)new HandlerExecutionListener.NoOpHandler());
        this.registry.addHandlers((Set)ImmutableSet.of((Object)this.handler));
    }

    @Test
    public void testCreate() throws Exception {
    }

    @Test
    public void testGet() throws Exception {
    }

    @Test
    public void testUpdate() throws Exception {
    }

    @Test
    public void testDelete() throws Exception {
    }

    @Test
    public void testSupportedFields() throws Exception {
        String path = "/mediaItems/@supportedFields";
        RestHandler operation = this.registry.getRestHandler(path, "GET");
        this.replay();
        List received = (List)operation.execute((Map)Maps.newHashMap(), null, (SecurityToken)this.token, (BeanConverter)this.converter).get();
        MediaItemHandlerTest.assertEquals((long)3L, (long)received.size());
        MediaItemHandlerTest.assertEquals((Object)"id", (Object)received.get(0).toString());
        MediaItemHandlerTest.assertEquals((Object)"language", (Object)received.get(1).toString());
        MediaItemHandlerTest.assertEquals((Object)"title", (Object)received.get(2).toString());
        this.verify();
    }
}

