/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.social.core.oauth;

import com.google.inject.AbstractModule;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.TypeLiteral;
import java.util.Collections;
import java.util.List;
import org.apache.shindig.auth.AuthenticationHandler;
import org.apache.shindig.common.PropertiesModule;
import org.apache.shindig.social.core.config.SocialApiGuiceModule;
import org.apache.shindig.social.core.oauth.AuthenticationHandlerProvider;
import org.junit.Assert;
import org.junit.Test;

public class AuthenticationProviderHandlerTest
extends Assert {
    @Test
    public void testCustomHandler() {
        Injector injector = Guice.createInjector((Module[])new Module[]{new SocialApiGuiceModule(), new CustomAuthHandlerProviderModule(), new PropertiesModule()});
        AuthenticationHandlerProvider provider = (AuthenticationHandlerProvider)injector.getInstance(AuthenticationHandlerProvider.class);
        AuthenticationProviderHandlerTest.assertEquals((long)0L, (long)provider.get().size());
        List handlers = (List)injector.getInstance(Key.get((TypeLiteral)new TypeLiteral<List<AuthenticationHandler>>(){}));
        AuthenticationProviderHandlerTest.assertEquals((long)0L, (long)handlers.size());
    }

    public static class CustomAuthHandlerProviderModule
    extends AbstractModule {
        protected void configure() {
            this.bind(AuthenticationHandlerProvider.class).to(ProvidesNoHandlers.class);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ProvidesNoHandlers
    extends AuthenticationHandlerProvider {
        public ProvidesNoHandlers() {
            super(null, null, null);
        }

        public List<AuthenticationHandler> get() {
            return Collections.emptyList();
        }
    }
}

