/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.social.opensocial.service;

import com.google.common.collect.Maps;
import com.google.inject.Guice;
import com.google.inject.Module;
import java.util.Map;
import org.apache.shindig.auth.SecurityToken;
import org.apache.shindig.common.testing.FakeGadgetToken;
import org.apache.shindig.protocol.conversion.BeanConverter;
import org.apache.shindig.protocol.conversion.BeanJsonConverter;
import org.apache.shindig.social.opensocial.service.SocialRequestItem;
import org.apache.shindig.social.opensocial.spi.GroupId;
import org.apache.shindig.social.opensocial.spi.UserId;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class SocialRequestItemTest
extends Assert {
    private static final FakeGadgetToken FAKE_TOKEN = new FakeGadgetToken();
    protected SocialRequestItem request;
    protected BeanJsonConverter converter;

    @Before
    public void setUp() throws Exception {
        FAKE_TOKEN.setAppId("12345");
        FAKE_TOKEN.setOwnerId("someowner");
        FAKE_TOKEN.setViewerId("someowner");
        this.converter = new BeanJsonConverter(Guice.createInjector((Module[])new Module[0]));
        this.request = new SocialRequestItem((Map)Maps.newHashMap(), (SecurityToken)FAKE_TOKEN, (BeanConverter)this.converter, this.converter);
    }

    @Test
    public void testGetUser() throws Exception {
        this.request.setParameter("userId", (Object)"@owner");
        SocialRequestItemTest.assertEquals((Object)UserId.Type.owner, (Object)((UserId)this.request.getUsers().iterator().next()).getType());
    }

    @Test
    public void testGetGroup() throws Exception {
        this.request.setParameter("groupId", (Object)"@self");
        SocialRequestItemTest.assertEquals((Object)GroupId.Type.self, (Object)this.request.getGroup().getType());
    }
}

