/*
 * Decompiled with CFR 0.152.
 */
package aa.control;

import aa.config.AuthorityConfiguration;
import aa.config.AuthorityResolver;
import aa.model.Aggregation;
import aa.model.Attribute;
import aa.model.InvalidAuthenticationException;
import aa.model.MetaInformation;
import aa.model.ResourceType;
import aa.model.Schema;
import aa.model.SchemaNotFoundException;
import aa.model.ServiceProvider;
import aa.model.UserAttribute;
import aa.oauth.ClientCredentialsAuthentication;
import aa.oauth.FederatedUserAuthenticationToken;
import aa.repository.ServiceProviderRepository;
import aa.service.AttributeAggregatorService;
import aa.service.ServiceProviderTranslationService;
import aa.serviceregistry.ServiceRegistry;
import java.io.IOException;
import java.io.InputStream;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.ClassPathResource;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.authority.AuthorityUtils;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.oauth2.provider.OAuth2Authentication;
import org.springframework.security.oauth2.provider.OAuth2Request;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(headers={"Content-Type=application/json"}, produces={"application/json"})
public class SCIMController {
    private static final Logger LOG = LoggerFactory.getLogger(SCIMController.class);
    private final String serviceProviderConfigJson;
    private final ServiceProviderRepository serviceProviderRepository;
    private final ServiceProviderTranslationService serviceProviderTranslationService;
    private final AttributeAggregatorService attributeAggregatorService;
    private final AuthorityConfiguration authorityConfiguration;
    private final ServiceRegistry serviceRegistry;
    private final String dateTime;
    private final String resourcelocation;
    private final String userlocationPrefix;

    @Autowired
    public SCIMController(@Value(value="${scim.server.environment}") String env, ServiceProviderRepository serviceProviderRepository, ServiceProviderTranslationService serviceProviderTranslationService, AttributeAggregatorService attributeAggregatorService, AuthorityResolver authorityResolver, ServiceRegistry serviceRegistry) throws IOException {
        this.serviceProviderRepository = serviceProviderRepository;
        this.serviceProviderTranslationService = serviceProviderTranslationService;
        this.attributeAggregatorService = attributeAggregatorService;
        this.authorityConfiguration = authorityResolver.getConfiguration();
        this.serviceRegistry = serviceRegistry;
        this.serviceProviderConfigJson = String.format(IOUtils.toString((InputStream)new ClassPathResource("scim/ServiceProviderConfig.template.json").getInputStream()), env);
        this.dateTime = DateTimeFormatter.RFC_1123_DATE_TIME.format(ZonedDateTime.now(ZoneId.of("GMT")));
        this.resourcelocation = String.format("https://aa.%s.nl/v2/ResourceTypes/Me", env);
        this.userlocationPrefix = String.format("https://aa.%s.nl/v2/Users/", env);
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/v2/ServiceProviderConfig"})
    public String serviceProviderConfiguration() {
        return this.serviceProviderConfigJson;
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/internal/v2/ResourceType"})
    public ResourceType internalResourceType(@RequestParam(value="serviceProviderEntityId") String serviceProviderEntityId) {
        OAuth2Authentication authentication = this.buildOAuth2Authentication(serviceProviderEntityId);
        return this.resourceType(authentication);
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/v2/ResourceType"})
    public ResourceType resourceType(OAuth2Authentication authentication) {
        this.assertClientCredentials(authentication);
        String clientId = authentication.getOAuth2Request().getClientId();
        String serviceProviderEntityId = this.serviceProviderTranslationService.translateClientId(clientId);
        Optional<ServiceProvider> serviceProvider = this.serviceRegistry.serviceProviderByEntityId(serviceProviderEntityId);
        if (!serviceProvider.isPresent()) {
            throw new SchemaNotFoundException("Service Provider " + serviceProviderEntityId + " is unknown");
        }
        MetaInformation metaInformation = new MetaInformation(this.dateTime, this.dateTime, this.resourcelocation, "ResourceType");
        return new ResourceType(serviceProviderEntityId, metaInformation);
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/internal/v2/Schema"})
    public Schema internalSchema(@RequestParam(value="serviceProviderEntityId") String serviceProviderEntityId) {
        OAuth2Authentication authentication = this.buildOAuth2Authentication(serviceProviderEntityId);
        return this.schema(authentication);
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/v2/Schema"})
    public Schema schema(OAuth2Authentication authentication) {
        this.assertClientCredentials(authentication);
        String clientId = authentication.getOAuth2Request().getClientId();
        String serviceProviderEntityId = this.serviceProviderTranslationService.translateClientId(clientId);
        Optional<ServiceProvider> sp = this.serviceProviderRepository.findByEntityId(serviceProviderEntityId);
        if (!sp.isPresent()) {
            throw new SchemaNotFoundException("ServiceProvider " + serviceProviderEntityId + " has no attribute aggregations configured");
        }
        List configuredAttributes = sp.get().getAggregations().stream().map(Aggregation::getAttributes).flatMap(Collection::stream).collect(Collectors.toList());
        List<Attribute> attributes = this.authorityConfiguration.getAttributes(configuredAttributes.stream().map(Attribute::getName).collect(Collectors.toSet()));
        List<Attribute> clonedAttributes = attributes.stream().map(this::eraseAuthorityId).collect(Collectors.toList());
        Schema schema = new Schema("Attribute schema for " + serviceProviderEntityId, "urn:scim:schemas:extension:surf:" + serviceProviderEntityId, serviceProviderEntityId, clonedAttributes);
        LOG.debug("Returning schema {} for {}", (Object)schema, (Object)serviceProviderEntityId);
        return schema;
    }

    @RequestMapping(method={RequestMethod.POST}, value={"/internal/v2/Me"})
    public Map<String, Object> internalMe(@RequestParam(value="serviceProviderEntityId") String serviceProviderEntityId, @RequestBody Map<String, String> inputParameters) {
        String clientId = this.serviceProviderTranslationService.translateServiceProviderEntityId(serviceProviderEntityId);
        OAuth2Request oauth2Request = this.buildOAuth2Request(clientId);
        String principal = inputParameters.get("urn:oasis:names:tc:SAML:1.1:nameid-format:unspecified");
        String eduPersonPrincipalName = inputParameters.get("urn:mace:dir:attribute-def:eduPersonPrincipalName");
        String schacHomeOrganization = inputParameters.get("urn:mace:terena.org:attribute-def:schacHomeOrganization");
        FederatedUserAuthenticationToken userAuthentication = new FederatedUserAuthenticationToken(eduPersonPrincipalName, schacHomeOrganization, principal, "N/A", AuthorityUtils.createAuthorityList((String[])new String[]{"ROLE_USER"}));
        OAuth2Authentication authentication = new OAuth2Authentication(oauth2Request, (Authentication)userAuthentication);
        return this.me(authentication);
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/v2/Me"})
    public Map<String, Object> me(OAuth2Authentication authentication) {
        this.assertAuthorizationCode(authentication);
        String clientId = authentication.getOAuth2Request().getClientId();
        String serviceProviderEntityId = this.serviceProviderTranslationService.translateClientId(clientId);
        Optional<ServiceProvider> sp = this.serviceProviderRepository.findByEntityId(serviceProviderEntityId);
        if (!sp.isPresent()) {
            throw new SchemaNotFoundException("ServiceProvider " + serviceProviderEntityId + " has no attribute aggregations configured");
        }
        FederatedUserAuthenticationToken userAuthentication = (FederatedUserAuthenticationToken)authentication.getUserAuthentication();
        List<UserAttribute> input = userAuthentication.getUserAttributes();
        List<UserAttribute> userAttributes = this.attributeAggregatorService.aggregate(sp.get(), input);
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        result.put("schemas", Collections.singletonList("urn:scim:schemas:extension:surf:" + serviceProviderEntityId));
        String id = UUID.randomUUID().toString();
        result.put("id", id);
        Map<String, List<UserAttribute>> grouped = userAttributes.stream().collect(Collectors.groupingBy(UserAttribute::getName));
        grouped.entrySet().forEach(entry -> result.put((String)entry.getKey(), ((List)entry.getValue()).stream().map(UserAttribute::getValues).flatMap(Collection::stream).collect(Collectors.toList())));
        result.put("meta", new MetaInformation(this.dateTime, this.dateTime, this.userlocationPrefix.concat(id), "User"));
        LOG.debug("Returning Me {} for {}", result, input);
        return result;
    }

    private OAuth2Request buildOAuth2Request(String clientId) {
        return new OAuth2Request(Collections.emptyMap(), clientId, SecurityContextHolder.getContext().getAuthentication().getAuthorities(), true, Collections.emptySet(), Collections.emptySet(), null, Collections.emptySet(), Collections.emptyMap());
    }

    private OAuth2Authentication buildOAuth2Authentication(@RequestParam(value="serviceProviderEntityId") String serviceProviderEntityId) {
        String clientId = this.serviceProviderTranslationService.translateServiceProviderEntityId(serviceProviderEntityId);
        OAuth2Request oauth2Request = this.buildOAuth2Request(clientId);
        return new OAuth2Authentication(oauth2Request, (Authentication)new ClientCredentialsAuthentication(clientId, Collections.emptyList()));
    }

    private void assertClientCredentials(OAuth2Authentication authentication) {
        this.assertCorrectAuthentication(authentication, ClientCredentialsAuthentication.class);
    }

    private void assertAuthorizationCode(OAuth2Authentication authentication) {
        this.assertCorrectAuthentication(authentication, FederatedUserAuthenticationToken.class);
    }

    private void assertCorrectAuthentication(OAuth2Authentication authentication, Class expectedAuthentication) {
        Authentication userAuthentication = authentication.getUserAuthentication();
        if (!userAuthentication.getClass().isAssignableFrom(expectedAuthentication)) {
            throw new InvalidAuthenticationException(String.format("Only accessible with %s code authentication. Actual authentication %s", expectedAuthentication.getName(), userAuthentication));
        }
    }

    private Attribute eraseAuthorityId(Attribute attribute) {
        Attribute clone = attribute.clone();
        clone.setAttributeAuthorityId(null);
        return clone;
    }
}

