/*
 * Decompiled with CFR 0.152.
 */
package aa.model;

import aa.model.Aggregation;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.ManyToMany;
import javax.persistence.Transient;

@Entity(name="service_providers")
public class ServiceProvider {
    @Id
    @GeneratedValue
    private Long id;
    @Column(name="entity_id")
    private String entityId;
    @Transient
    private String name;
    @Transient
    private String description;
    @Transient
    private boolean attributeAggregationRequired;
    @ManyToMany(mappedBy="serviceProviders", fetch=FetchType.EAGER)
    @JsonIgnore
    private Set<Aggregation> aggregations = new HashSet<Aggregation>();

    public ServiceProvider(String entityId) {
        this.entityId = entityId;
    }

    public ServiceProvider() {
    }

    public ServiceProvider(String entityId, String description, String name, boolean attributeAggregationRequired) {
        this.entityId = entityId;
        this.description = description;
        this.name = name;
        this.attributeAggregationRequired = attributeAggregationRequired;
    }

    public ServiceProvider(Set<Aggregation> aggregations) {
        this.aggregations = aggregations;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getEntityId() {
        return this.entityId;
    }

    public void setEntityId(String entityId) {
        this.entityId = entityId;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Set<Aggregation> getAggregations() {
        return this.aggregations;
    }

    public void setAggregations(Set<Aggregation> aggregations) {
        this.aggregations = aggregations;
    }

    public boolean isAttributeAggregationRequired() {
        return this.attributeAggregationRequired;
    }

    public void setAttributeAggregationRequired(boolean attributeAggregationRequired) {
        this.attributeAggregationRequired = attributeAggregationRequired;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ServiceProvider)) {
            return false;
        }
        ServiceProvider that = (ServiceProvider)o;
        return Objects.equals(this.entityId, that.entityId);
    }

    public int hashCode() {
        return Objects.hash(this.entityId);
    }

    public String toString() {
        return "ServiceProvider{entityId='" + this.getEntityId() + '\'' + '}';
    }
}

