/*
 * Decompiled with CFR 0.152.
 */
package aa.serviceregistry;

import aa.serviceregistry.BasicAuthenticationUrlResource;
import aa.serviceregistry.ClassPathResourceServiceRegistry;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.springframework.core.io.Resource;
import org.springframework.http.client.SimpleClientHttpRequestFactory;
import org.springframework.web.client.RestTemplate;

public class UrlResourceServiceRegistry
extends ClassPathResourceServiceRegistry {
    private final BasicAuthenticationUrlResource urlResource;
    private final RestTemplate restTemplate = new RestTemplate();
    private final int period;
    private final String spRemotePath;

    public UrlResourceServiceRegistry(String username, String password, String spRemotePath, int period) throws IOException {
        super(false);
        this.urlResource = new BasicAuthenticationUrlResource(spRemotePath, username, password);
        this.spRemotePath = spRemotePath;
        this.period = period;
        SimpleClientHttpRequestFactory requestFactory = (SimpleClientHttpRequestFactory)this.restTemplate.getRequestFactory();
        requestFactory.setConnectTimeout(5000);
        Executors.newScheduledThreadPool(1).scheduleAtFixedRate(this::initializeMetadata, period, period, TimeUnit.MINUTES);
        super.initializeMetadata();
    }

    @Override
    protected List<Resource> getResources() {
        this.LOG.debug("Fetching SP metadata entries from {}", (Object)this.spRemotePath);
        return Collections.singletonList(this.urlResource);
    }

    @Override
    protected void initializeMetadata() {
        try {
            if (this.urlResource.isModified(this.period)) {
                super.initializeMetadata();
            } else {
                this.LOG.debug("Not refreshing SP metadata. Not modified");
            }
        }
        catch (IOException e) {
            this.LOG.error("Error in refreshing / initializing metadata", (Throwable)e);
        }
    }
}

