/*
 * Decompiled with CFR 0.152.
 */
package aa.web;

import java.util.Collection;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.authority.AuthorityUtils;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.util.Assert;

public class BasicAuthenticationManager
implements AuthenticationManager {
    private final String userName;
    private final String password;

    public BasicAuthenticationManager(String userName, String password) {
        Assert.notNull((Object)userName);
        Assert.notNull((Object)password);
        this.userName = userName;
        this.password = password;
    }

    public Authentication authenticate(Authentication authentication) throws AuthenticationException {
        if (!this.userName.equals(authentication.getPrincipal())) {
            throw new UsernameNotFoundException("Unknown user: " + authentication.getPrincipal());
        }
        if (!this.password.equals(authentication.getCredentials())) {
            throw new BadCredentialsException("Bad credentials");
        }
        return new UsernamePasswordAuthenticationToken(authentication.getPrincipal(), authentication.getCredentials(), (Collection)AuthorityUtils.createAuthorityList((String[])new String[]{"ROLE_USER", "ROLE_ADMIN"}));
    }
}

