/*
 * Decompiled with CFR 0.152.
 */
package aa.web;

import java.io.IOException;
import java.util.regex.Pattern;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.springframework.util.Assert;

public class RegExpRequestMatcherFilter
implements Filter {
    private final Filter filter;
    private final Pattern pattern;

    public RegExpRequestMatcherFilter(Filter filter, String regExp) {
        Assert.notNull((Object)filter);
        Assert.notNull((Object)regExp);
        this.filter = filter;
        this.pattern = Pattern.compile(regExp);
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        this.filter.init(filterConfig);
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        String url = this.getRequestPath((HttpServletRequest)request);
        if (this.pattern.matcher(url).matches()) {
            this.filter.doFilter(request, response, chain);
        } else {
            chain.doFilter(request, response);
        }
    }

    public void destroy() {
        this.filter.destroy();
    }

    private String getRequestPath(HttpServletRequest request) {
        String url = request.getServletPath();
        if (request.getPathInfo() != null) {
            url = url + request.getPathInfo();
        }
        return url;
    }
}

