/*
 * Decompiled with CFR 0.152.
 */
package aa.aggregators.sab;

import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.IntStream;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public class SabResponseParser {
    public List<String> parse(Reader soap) throws XMLStreamException {
        XMLInputFactory factory = XMLInputFactory.newInstance();
        XMLStreamReader reader = factory.createXMLStreamReader(soap);
        ArrayList<String> roles = new ArrayList<String>();
        boolean processRoles = false;
        while (reader.hasNext()) {
            block0 : switch (reader.next()) {
                case 1: {
                    switch (reader.getLocalName()) {
                        case "Attribute": {
                            if (!this.hasAttributeValue(reader, "urn:oid:1.3.6.1.4.1.5923.1.1.1.7")) break;
                            processRoles = true;
                            break block0;
                        }
                        case "AttributeValue": {
                            if (!processRoles) break;
                            roles.add(reader.getElementText());
                        }
                    }
                    break;
                }
                case 2: {
                    if (!processRoles || !reader.getLocalName().equals("Attribute")) break;
                    return roles;
                }
            }
        }
        return roles;
    }

    private boolean hasAttributeValue(XMLStreamReader reader, String attributeValue) {
        return IntStream.range(0, reader.getAttributeCount()).mapToObj(i -> reader.getAttributeValue(i)).anyMatch(v -> v != null && v.equals(attributeValue));
    }
}

