/*
 * Decompiled with CFR 0.152.
 */
package aa.authz;

import aa.oauth.ClientCredentialsAuthentication;
import aa.oauth.FederatedUserAuthenticationToken;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.oauth2.provider.token.DefaultUserAuthenticationConverter;
import org.springframework.util.Assert;

public class AuthzSchacHomeAwareUserAuthenticationConverter
extends DefaultUserAuthenticationConverter {
    private static final Set<GrantedAuthority> DEFAULT_AUTHORITIES = Collections.singleton(new SimpleGrantedAuthority("ROLE_USER"));
    private static final String SCHAC_HOME_KEY = "schacHomeOrganization";
    private static final String CLIENT_ID = "client_id";

    public Authentication extractAuthentication(Map<String, ?> authenticationAttributes) {
        Authentication authentication = super.extractAuthentication(authenticationAttributes);
        if (authentication == null) {
            Assert.isTrue((boolean)authenticationAttributes.containsKey(CLIENT_ID), (String)String.format("Authentication (%s) does not contain %s attribute", authenticationAttributes, CLIENT_ID));
            return new ClientCredentialsAuthentication((String)authenticationAttributes.get(CLIENT_ID), DEFAULT_AUTHORITIES);
        }
        Assert.isTrue((boolean)authenticationAttributes.containsKey(SCHAC_HOME_KEY), (String)String.format("Authentication (%s) does not contain %s attribute", authenticationAttributes, SCHAC_HOME_KEY));
        return new FederatedUserAuthenticationToken((String)authenticationAttributes.get("eduPersonPrincipalName"), (String)authenticationAttributes.get(SCHAC_HOME_KEY), authentication.getPrincipal(), authentication.getCredentials(), authentication.getAuthorities());
    }
}

