/*
 * Decompiled with CFR 0.152.
 */
package aa.config;

import aa.model.Attribute;
import aa.model.AttributeAuthorityConfiguration;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;

public class AuthorityConfiguration {
    private Map<String, AttributeAuthorityConfiguration> authorities = new HashMap<String, AttributeAuthorityConfiguration>();

    public AuthorityConfiguration() {
    }

    public AuthorityConfiguration(List<AttributeAuthorityConfiguration> authorities) {
        this.setAuthorities(authorities);
    }

    public Collection<AttributeAuthorityConfiguration> getAuthorities() {
        return this.authorities.values();
    }

    public void setAuthorities(List<AttributeAuthorityConfiguration> authorities) {
        this.authorities = authorities.stream().collect(Collectors.toMap(AttributeAuthorityConfiguration::getId, Function.identity()));
    }

    public AttributeAuthorityConfiguration getAuthorityById(String authorityId) {
        return this.authorities.get(authorityId);
    }

    public List<Attribute> getAttributes(Set<String> names) {
        return this.getAuthorities().stream().map(AttributeAuthorityConfiguration::getAttributes).flatMap(Collection::stream).filter(attribute -> names.contains(attribute.getName())).collect(Collectors.toList());
    }

    public String toString() {
        return "AuthorityConfiguration{authorities=" + this.authorities + '}';
    }
}

