/*
 * Decompiled with CFR 0.152.
 */
package aa.model;

import aa.model.Attribute;
import aa.model.ServiceProvider;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import org.hibernate.annotations.LazyCollection;
import org.hibernate.annotations.LazyCollectionOption;

@Entity(name="aggregations")
public class Aggregation {
    @Id
    @GeneratedValue
    private Long id;
    @Column
    private String name;
    @ManyToMany(cascade={CascadeType.PERSIST, CascadeType.REFRESH, CascadeType.DETACH, CascadeType.MERGE}, fetch=FetchType.EAGER)
    @LazyCollection(value=LazyCollectionOption.FALSE)
    @JoinTable(name="aggregations_service_providers", joinColumns={@JoinColumn(name="aggregation_id", referencedColumnName="id")}, inverseJoinColumns={@JoinColumn(name="service_provider_id", referencedColumnName="id")})
    private Set<ServiceProvider> serviceProviders = new HashSet<ServiceProvider>();
    @ManyToMany(cascade={CascadeType.ALL}, fetch=FetchType.EAGER)
    @LazyCollection(value=LazyCollectionOption.FALSE)
    @JoinTable(name="aggregations_attributes", joinColumns={@JoinColumn(name="aggregation_id", referencedColumnName="id")}, inverseJoinColumns={@JoinColumn(name="attribute_id", referencedColumnName="id")})
    private Set<Attribute> attributes = new HashSet<Attribute>();
    @Column
    private String userIdentifier;
    @Column
    private String userDisplayName;
    @Column(name="ts")
    private Date created;

    public Aggregation() {
    }

    public Aggregation(Set<Attribute> attributes) {
        this.attributes = attributes;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Set<ServiceProvider> getServiceProviders() {
        return this.serviceProviders;
    }

    public void setServiceProviders(Set<ServiceProvider> serviceProviders) {
        this.serviceProviders = serviceProviders;
    }

    public Set<Attribute> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(Set<Attribute> attributes) {
        this.attributes = attributes;
    }

    public String getUserIdentifier() {
        return this.userIdentifier;
    }

    public void setUserIdentifier(String userIdentifier) {
        this.userIdentifier = userIdentifier;
    }

    public String getUserDisplayName() {
        return this.userDisplayName;
    }

    public void setUserDisplayName(String userDisplayName) {
        this.userDisplayName = userDisplayName;
    }

    public Date getCreated() {
        return this.created;
    }

    public void setCreated(Date created) {
        this.created = created;
    }

    public String toString() {
        return "Aggregation{id=" + this.getId() + ", name='" + this.getName() + '\'' + ", serviceProviders=" + this.getServiceProviders() + ", attributes=" + this.getAttributes() + ", userIdentifier='" + this.getUserIdentifier() + '\'' + ", userDisplayName='" + this.getUserDisplayName() + '\'' + ", created=" + this.getCreated() + '}';
    }
}

