/*
 * Decompiled with CFR 0.152.
 */
package aa.oauth;

import aa.oauth.DecisionResourceServerTokenServices;
import aa.util.StreamUtils;
import java.util.List;
import java.util.Optional;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.oauth2.common.OAuth2AccessToken;
import org.springframework.security.oauth2.common.exceptions.InvalidTokenException;
import org.springframework.security.oauth2.provider.OAuth2Authentication;

public class CompositeDecisionResourceServerTokenServices
implements DecisionResourceServerTokenServices {
    private final List<DecisionResourceServerTokenServices> tokenServices;

    public CompositeDecisionResourceServerTokenServices(List<DecisionResourceServerTokenServices> tokenServices) {
        this.tokenServices = tokenServices;
    }

    @Override
    public boolean canHandle(String accessToken) {
        return this.tokenServices.stream().anyMatch(tokenServices -> tokenServices.canHandle(accessToken));
    }

    public OAuth2Authentication loadAuthentication(String accessToken) throws AuthenticationException, InvalidTokenException {
        Optional tokenService = this.tokenServices.stream().filter(tokenServices -> tokenServices.canHandle(accessToken)).collect(StreamUtils.singletonOptionalCollector());
        return ((DecisionResourceServerTokenServices)tokenService.orElseThrow(() -> new InvalidTokenException("Can not handle accessToken " + accessToken))).loadAuthentication(accessToken);
    }

    public OAuth2AccessToken readAccessToken(String accessToken) {
        Optional tokenService = this.tokenServices.stream().filter(tokenServices -> tokenServices.canHandle(accessToken)).collect(StreamUtils.singletonOptionalCollector());
        return ((DecisionResourceServerTokenServices)tokenService.orElseThrow(() -> new InvalidTokenException("Can not handle accessToken " + accessToken))).readAccessToken(accessToken);
    }
}

