/*
 * Decompiled with CFR 0.152.
 */
package aa.service;

import aa.aggregators.AttributeAggregator;
import aa.cache.UserAttributeCache;
import aa.config.AuthorityConfiguration;
import aa.model.Aggregation;
import aa.model.Attribute;
import aa.model.AttributeAuthorityConfiguration;
import aa.model.ServiceProvider;
import aa.model.UserAttribute;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinTask;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class AttributeAggregatorService {
    private static final Logger LOG = LoggerFactory.getLogger(AttributeAggregatorService.class);
    private final Map<String, AttributeAggregator> aggregators;
    private final ForkJoinPool forkJoinPool;
    private final AuthorityConfiguration configuration;
    private final UserAttributeCache cache;

    public AttributeAggregatorService(List<AttributeAggregator> aggregators, AuthorityConfiguration configuration, UserAttributeCache cache) {
        Assert.notEmpty(aggregators);
        this.aggregators = aggregators.stream().collect(Collectors.toMap(AttributeAggregator::getAttributeAuthorityId, Function.identity()));
        this.forkJoinPool = new ForkJoinPool(20 * aggregators.size());
        this.configuration = configuration;
        this.cache = cache;
    }

    public List<UserAttribute> aggregate(ServiceProvider serviceProvider, List<UserAttribute> input) {
        long start = System.currentTimeMillis();
        LOG.debug("Started to aggregate attributes for SP {} and input {}", (Object)serviceProvider, input);
        List attributes = serviceProvider.getAggregations().stream().map(Aggregation::getAttributes).flatMap(Collection::stream).collect(Collectors.toList());
        Set<AttributeAuthorityConfiguration> authorityConfigurations = attributes.stream().map(attribute -> this.configuration.getAuthorityById(attribute.getAttributeAuthorityId())).collect(Collectors.toSet());
        List<UserAttribute> aggregatedAttributes = this.getUserAttributes(input, authorityConfigurations);
        List<UserAttribute> result = aggregatedAttributes.stream().filter(userAttribute -> this.allowedAttribute(attributes, (UserAttribute)userAttribute)).collect(Collectors.toList());
        result.forEach(userAttribute -> {
            Attribute attribute = attributes.stream().filter(attr -> attr.getAttributeAuthorityId().equals(userAttribute.getSource()) && attr.getName().equals(userAttribute.getName())).findAny().orElseThrow(() -> new IllegalArgumentException(String.format("Unknown UserAttribute %s returned for SP %s", userAttribute, serviceProvider)));
            userAttribute.setSkipConsent(attribute.isSkipConsent());
        });
        LOG.debug("Finished aggregating attributes in {} millis for SP {} and input {} with result {}", new Object[]{System.currentTimeMillis() - start, serviceProvider, input, result});
        return result;
    }

    public List<UserAttribute> aggregateNoServiceCheck(List<UserAttribute> input) {
        long start = System.currentTimeMillis();
        LOG.debug("Started to aggregate attributes without Service check for input {}", input);
        List<UserAttribute> aggregatedAttributes = this.getUserAttributes(input, this.configuration.getAuthorities());
        LOG.debug("Finished aggregating attributes without Service check in {} millis for input {} with result {}", new Object[]{System.currentTimeMillis() - start, input, aggregatedAttributes});
        return aggregatedAttributes;
    }

    private List<UserAttribute> getUserAttributes(List<UserAttribute> input, Collection<AttributeAuthorityConfiguration> authorityConfigurations) {
        List aggregatedAttributes;
        List inputNames = input.stream().filter(userAttribute -> userAttribute.getValues().stream().anyMatch(StringUtils::hasText)).map(UserAttribute::getName).collect(Collectors.toList());
        List attributeAggregators = authorityConfigurations.stream().map(attributeAuthority -> this.aggregators.get(attributeAuthority.getId())).filter(attributeAggregator -> inputNames.containsAll(attributeAggregator.attributeKeysRequired())).collect(Collectors.toList());
        try {
            aggregatedAttributes = (List)((ForkJoinTask)this.forkJoinPool.submit(() -> attributeAggregators.parallelStream().map(aggregator -> this.doAggregate(input, (AttributeAggregator)aggregator)).flatMap(Collection::stream).collect(Collectors.toList()))).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException("Unable to schedule querying of attribute aggregators.", e);
        }
        return aggregatedAttributes;
    }

    private List<UserAttribute> doAggregate(List<UserAttribute> input, AttributeAggregator aggregator) {
        try {
            Optional<String> cacheKey = aggregator.cacheKey(input);
            Optional<List<UserAttribute>> userAttributesFromCache = this.cache.get(cacheKey);
            if (userAttributesFromCache.isPresent()) {
                return userAttributesFromCache.get();
            }
            List<UserAttribute> userAttributes = aggregator.aggregate(input);
            this.cache.put(cacheKey, userAttributes);
            return userAttributes;
        }
        catch (IOException | RuntimeException e) {
            LOG.warn("AttributeAggregator {} threw exception: {} ", (Object)aggregator, (Object)e);
            return Collections.emptyList();
        }
    }

    private boolean allowedAttribute(List<Attribute> attributes, UserAttribute userAttribute) {
        return attributes.stream().anyMatch(attribute -> userAttribute.getSource().equals(attribute.getAttributeAuthorityId()) && userAttribute.getName().equals(attribute.getName()));
    }
}

