/*
 * Decompiled with CFR 0.152.
 */
package aa.shibboleth;

import aa.shibboleth.FederatedUser;
import javax.servlet.http.HttpServletRequest;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.core.authority.AuthorityUtils;
import org.springframework.security.web.authentication.preauth.AbstractPreAuthenticatedProcessingFilter;
import org.springframework.util.StringUtils;

public class ShibbolethPreAuthenticatedProcessingFilter
extends AbstractPreAuthenticatedProcessingFilter {
    public static final String UID_HEADER_NAME = "uid";
    public static final String DISPLAY_NAME_HEADER_NAME = "displayname";

    public ShibbolethPreAuthenticatedProcessingFilter(AuthenticationManager authenticationManager) {
        this.setAuthenticationManager(authenticationManager);
    }

    protected Object getPreAuthenticatedPrincipal(HttpServletRequest request) {
        String uid = request.getHeader(UID_HEADER_NAME);
        String displayName = request.getHeader(DISPLAY_NAME_HEADER_NAME);
        if (StringUtils.isEmpty((Object)uid) || StringUtils.isEmpty((Object)displayName)) {
            return null;
        }
        return new FederatedUser(uid, displayName, AuthorityUtils.createAuthorityList((String[])new String[]{"ROLE_USER", "ROLE_ADMIN"}));
    }

    protected Object getPreAuthenticatedCredentials(HttpServletRequest request) {
        return "N/A";
    }
}

