/*
 * Decompiled with CFR 0.152.
 */
package aa.web;

import aa.authz.AuthzResourceServerTokenServices;
import aa.authz.AuthzSchacHomeAwareUserAuthenticationConverter;
import aa.oauth.CachedRemoteTokenServices;
import aa.oauth.CompositeDecisionResourceServerTokenServices;
import aa.oauth.DecisionResourceServerTokenServices;
import aa.oidc.OidcRemoteTokenServices;
import aa.shibboleth.ShibbolethPreAuthenticatedProcessingFilter;
import aa.shibboleth.ShibbolethUserDetailService;
import aa.shibboleth.mock.MockShibbolethFilter;
import aa.web.BasicAuthenticationManager;
import aa.web.CsrfProtectionMatcher;
import aa.web.CsrfTokenResponseHeaderBindingFilter;
import aa.web.SessionAliveFilter;
import java.util.Arrays;
import javax.servlet.Filter;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.core.env.Environment;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.config.annotation.authentication.builders.AuthenticationManagerBuilder;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.builders.WebSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configuration.WebSecurityConfigurerAdapter;
import org.springframework.security.config.annotation.web.configurers.ExpressionUrlAuthorizationConfigurer;
import org.springframework.security.config.http.SessionCreationPolicy;
import org.springframework.security.core.userdetails.AuthenticationUserDetailsService;
import org.springframework.security.oauth2.config.annotation.web.configuration.EnableResourceServer;
import org.springframework.security.oauth2.config.annotation.web.configuration.ResourceServerConfigurer;
import org.springframework.security.oauth2.config.annotation.web.configurers.ResourceServerSecurityConfigurer;
import org.springframework.security.oauth2.provider.authentication.BearerTokenExtractor;
import org.springframework.security.oauth2.provider.authentication.TokenExtractor;
import org.springframework.security.oauth2.provider.token.AccessTokenConverter;
import org.springframework.security.oauth2.provider.token.DefaultAccessTokenConverter;
import org.springframework.security.oauth2.provider.token.ResourceServerTokenServices;
import org.springframework.security.oauth2.provider.token.UserAuthenticationConverter;
import org.springframework.security.web.authentication.preauth.AbstractPreAuthenticatedProcessingFilter;
import org.springframework.security.web.authentication.preauth.PreAuthenticatedAuthenticationProvider;
import org.springframework.security.web.authentication.www.BasicAuthenticationFilter;
import org.springframework.security.web.csrf.CsrfFilter;
import org.springframework.security.web.util.matcher.RequestMatcher;

@Configuration
@EnableWebSecurity
@EnableResourceServer
public class WebSecurityConfigurer {
    @Autowired
    public void configureGlobal(AuthenticationManagerBuilder auth) throws Exception {
        PreAuthenticatedAuthenticationProvider authenticationProvider = new PreAuthenticatedAuthenticationProvider();
        authenticationProvider.setPreAuthenticatedUserDetailsService((AuthenticationUserDetailsService)new ShibbolethUserDetailService());
        auth.authenticationProvider((AuthenticationProvider)authenticationProvider);
    }

    @Configuration
    @Order
    public static class ScimSecurityConfigurationAdapter
    extends WebSecurityConfigurerAdapter
    implements ResourceServerConfigurer {
        @Value(value="${attribute.aggregation.user.name}")
        private String attributeAggregationUserName;
        @Value(value="${attribute.aggregation.user.password}")
        private String attributeAggregationPassword;
        private boolean configured = false;
        @Value(value="${authz.checkToken.endpoint.url}")
        private String authzCheckTokenEndpointUrl;
        @Value(value="${authz.checkToken.clientId}")
        private String authzCheckTokenClientId;
        @Value(value="${authz.checkToken.secret}")
        private String authzCheckTokenSecret;
        @Value(value="${oidc.checkToken.endpoint.url}")
        private String oidcCheckTokenEndpointUrl;
        @Value(value="${oidc.checkToken.clientId}")
        private String oidcCheckTokenClientId;
        @Value(value="${oidc.checkToken.secret}")
        private String oidcCheckTokenSecret;
        @Value(value="${checkToken.cache}")
        private boolean checkTokenCache;
        @Value(value="${checkToken.cache.duration.milliSeconds}")
        private int checkTokenCacheDurationMilliseconds;

        public void configure(HttpSecurity http) throws Exception {
            if (this.configured) {
                return;
            }
            this.configured = true;
            ((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((HttpSecurity)((HttpSecurity)http.antMatcher("/**").sessionManagement().sessionCreationPolicy(SessionCreationPolicy.STATELESS).and()).csrf().disable()).addFilterBefore((Filter)new BasicAuthenticationFilter((AuthenticationManager)new BasicAuthenticationManager(this.attributeAggregationUserName, this.attributeAggregationPassword)), BasicAuthenticationFilter.class).authorizeRequests().antMatchers(new String[]{"/v2/ResourceType", "/v2/Me", "/v2/Schema"})).access("#oauth2.hasScope('attribute-aggregation')").antMatchers(new String[]{"/v2/query"})).access("#oauth2.hasScope('saml-attribute-query')").antMatchers(new String[]{"/attribute/**"})).hasRole("ADMIN").antMatchers(new String[]{"/**"})).hasRole("USER");
        }

        public void configure(ResourceServerSecurityConfigurer resources) throws Exception {
            resources.resourceId("attribute-aggregator").stateless(false).tokenServices((ResourceServerTokenServices)this.resourceServerTokenServices()).tokenExtractor(this.tokenExtractor());
        }

        private DecisionResourceServerTokenServices resourceServerTokenServices() {
            CompositeDecisionResourceServerTokenServices tokenServices = new CompositeDecisionResourceServerTokenServices(Arrays.asList(this.oidcResourceServerTokenServices(), this.authzResourceServerTokenServices()));
            return this.checkTokenCache ? new CachedRemoteTokenServices(tokenServices, this.checkTokenCacheDurationMilliseconds, this.checkTokenCacheDurationMilliseconds) : tokenServices;
        }

        private DecisionResourceServerTokenServices oidcResourceServerTokenServices() {
            return new OidcRemoteTokenServices(this.oidcCheckTokenEndpointUrl, this.oidcCheckTokenClientId, this.oidcCheckTokenSecret);
        }

        private DecisionResourceServerTokenServices authzResourceServerTokenServices() {
            DefaultAccessTokenConverter accessTokenConverter = new DefaultAccessTokenConverter();
            accessTokenConverter.setUserTokenConverter((UserAuthenticationConverter)new AuthzSchacHomeAwareUserAuthenticationConverter());
            return new AuthzResourceServerTokenServices(this.authzCheckTokenClientId, this.authzCheckTokenSecret, this.authzCheckTokenEndpointUrl, (AccessTokenConverter)accessTokenConverter);
        }

        private TokenExtractor tokenExtractor() {
            return new BearerTokenExtractor(){

                protected String extractToken(HttpServletRequest request) {
                    return this.extractHeaderToken(request);
                }
            };
        }
    }

    @Order(value=1)
    @Configuration
    public static class InternalSecurityConfigurationAdapter
    extends WebSecurityConfigurerAdapter {
        @Autowired
        private Environment environment;

        public void configure(WebSecurity web) throws Exception {
            web.ignoring().antMatchers(new String[]{"/health", "/v2/ServiceProviderConfig"});
        }

        protected void configure(HttpSecurity http) throws Exception {
            ((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((HttpSecurity)((HttpSecurity)http.antMatcher("/internal/**").sessionManagement().sessionCreationPolicy(SessionCreationPolicy.IF_REQUIRED).and()).csrf().requireCsrfProtectionMatcher((RequestMatcher)new CsrfProtectionMatcher()).and()).addFilterAfter((Filter)new CsrfTokenResponseHeaderBindingFilter(), CsrfFilter.class).addFilterBefore((Filter)new SessionAliveFilter(), CsrfFilter.class).addFilterBefore((Filter)new ShibbolethPreAuthenticatedProcessingFilter(this.authenticationManagerBean()), AbstractPreAuthenticatedProcessingFilter.class).authorizeRequests().antMatchers(new String[]{"/internal/**"})).hasRole("ADMIN");
            if (this.environment.acceptsProfiles(new String[]{"no-csrf"})) {
                http.csrf().disable();
            }
            if (this.environment.acceptsProfiles(new String[]{"dev", "no-csrf"})) {
                http.addFilterBefore((Filter)new MockShibbolethFilter(), ShibbolethPreAuthenticatedProcessingFilter.class);
            }
        }
    }
}

