/*
 * Decompiled with CFR 0.152.
 */
package aa.aggregators;

import aa.aggregators.AttributeAggregator;
import aa.aggregators.idin.IdinAttributeAggregator;
import aa.aggregators.orcid.OrcidAttributeAggregator;
import aa.aggregators.sab.SabAttributeAggregator;
import aa.aggregators.test.TestingAttributeAggregator;
import aa.aggregators.voot.VootAttributeAggregator;
import aa.cache.UserAttributeCache;
import aa.config.AuthorityConfiguration;
import aa.config.AuthorityResolver;
import aa.model.AttributeAuthorityConfiguration;
import aa.service.AttributeAggregatorService;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Profile;

@Configuration
public class AttributeAggregatorConfiguration {
    @Value(value="${authorization.accessToken.url}")
    private String authorizationAccessTokenUrl;
    @Value(value="${scim.server.environment}")
    private String environment;
    @Autowired
    private AuthorityResolver authorityResolver;
    @Autowired
    private UserAttributeCache userAttributeCache;

    @Bean
    @Profile(value={"aa-test"})
    public AttributeAggregatorService testingAttributeAggregatorService() {
        return this.getAttributeAggregatorService(config -> new TestingAttributeAggregator((AttributeAuthorityConfiguration)config, false));
    }

    @Bean
    @Profile(value={"!aa-test"})
    public AttributeAggregatorService attributeAggregatorService() {
        return this.getAttributeAggregatorService(this::attributeAggregatorById);
    }

    private AttributeAggregatorService getAttributeAggregatorService(Function<AttributeAuthorityConfiguration, AttributeAggregator> aggregatorFunction) {
        AuthorityConfiguration configuration = this.authorityResolver.getConfiguration();
        List<AttributeAggregator> attributeAggregators = configuration.getAuthorities().stream().map(aggregatorFunction).collect(Collectors.toList());
        return new AttributeAggregatorService(attributeAggregators, configuration, this.userAttributeCache);
    }

    private AttributeAggregator attributeAggregatorById(AttributeAuthorityConfiguration configuration) {
        String id;
        switch (id = configuration.getId()) {
            case "sab": {
                return new SabAttributeAggregator(configuration);
            }
            case "voot": {
                return new VootAttributeAggregator(configuration, this.authorizationAccessTokenUrl);
            }
            case "orcid": {
                return new OrcidAttributeAggregator(configuration, this.environment);
            }
            case "idin": {
                return new IdinAttributeAggregator(configuration);
            }
        }
        if (id.startsWith("test:")) {
            return new TestingAttributeAggregator(configuration, false);
        }
        throw new IllegalArgumentException(String.format("Authority with id %s is unknown", id));
    }
}

