/*
 * Decompiled with CFR 0.152.
 */
package aa.aggregators.orcid;

import aa.aggregators.AbstractAttributeAggregator;
import aa.model.AttributeAuthorityConfiguration;
import aa.model.UserAttribute;
import aa.util.StreamUtils;
import java.net.URI;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.springframework.util.CollectionUtils;
import org.springframework.web.util.UriComponentsBuilder;

public class OrcidAttributeAggregator
extends AbstractAttributeAggregator {
    private final Pattern orcidValuePattern = Pattern.compile("\\QStringAttributeValue{value=\\E(.*?)}");
    private final Pattern orcidPattern = Pattern.compile("\\Qhttp://orcid.org/\\E[0-9]{4}-[0-9]{4}-[0-9]{4}-[0-9]{3}[0-9|X]{1}");
    private final String requester;

    public OrcidAttributeAggregator(AttributeAuthorityConfiguration attributeAuthorityConfiguration, String serverEnvironment) {
        super(attributeAuthorityConfiguration);
        this.requester = String.format("https://aa.%s.nl", serverEnvironment);
    }

    @Override
    public List<UserAttribute> aggregate(List<UserAttribute> input) {
        String eppn = this.getUserAttributeSingleValue(input, "urn:mace:dir:attribute-def:eduPersonPrincipalName");
        URI uri = UriComponentsBuilder.fromUri((URI)this.endpoint()).queryParam("requester", new Object[]{this.requester}).queryParam("principal", new Object[]{eppn}).build().encode().toUri();
        Map body = (Map)this.getRestTemplate().getForEntity(uri, Map.class).getBody();
        this.LOG.debug("Retrieved ORCID with request: {} and response: {}", (Object)uri, (Object)body);
        List<String> orcidValues = this.getOrcid(body);
        return this.mapValuesToUserAttribute("urn:mace:dir:attribute-def:eduPersonOrcid", orcidValues.stream().filter(this::isValidOrcidId).collect(Collectors.toList()));
    }

    private List<String> getOrcid(Map<String, Object> body) {
        List values;
        Optional optional;
        List attributes = (List)body.get("attributes");
        if (!CollectionUtils.isEmpty((Collection)attributes) && (optional = attributes.stream().filter(map -> "orcid".equals(map.get("name"))).collect(StreamUtils.singletonOptionalCollector())).isPresent() && !CollectionUtils.isEmpty((Collection)(values = (List)((Map)optional.get()).get("values")))) {
            return values.stream().map(this::extractOrcidValue).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    private Optional<String> extractOrcidValue(String value) {
        Matcher matcher = this.orcidValuePattern.matcher(value);
        return matcher.find() ? Optional.of(matcher.group(1)) : Optional.empty();
    }

    private boolean isValidOrcidId(String value) {
        boolean matches = this.orcidPattern.matcher(value).matches();
        if (!matches) {
            this.LOG.warn("Received invalid ORCID {}", (Object)value);
        }
        return matches;
    }
}

