/*
 * Decompiled with CFR 0.152.
 */
package aa.aggregators.test;

import aa.aggregators.AbstractAttributeAggregator;
import aa.model.AttributeAuthorityConfiguration;
import aa.model.UserAttribute;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpMethod;
import org.springframework.http.RequestEntity;

public class TestingAttributeAggregator
extends AbstractAttributeAggregator {
    private final boolean useEndpoint;

    public TestingAttributeAggregator(AttributeAuthorityConfiguration attributeAuthorityConfiguration, boolean useEndpoint) {
        super(attributeAuthorityConfiguration);
        this.useEndpoint = useEndpoint;
    }

    @Override
    public List<UserAttribute> aggregate(List<UserAttribute> input) {
        if (this.useEndpoint) {
            return (List)this.getRestTemplate().exchange(new RequestEntity(HttpMethod.GET, this.endpoint()), (ParameterizedTypeReference)new ParameterizedTypeReference<List<UserAttribute>>(){}).getBody();
        }
        AttributeAuthorityConfiguration configuration = this.getAttributeAuthorityConfiguration();
        return configuration.getAttributes().stream().map(attribute -> new UserAttribute(attribute.getName(), Collections.singletonList("urn:x-surfnet:" + this.getAttributeAuthorityId() + ":test"), configuration.getId())).collect(Collectors.toList());
    }
}

