/*
 * Decompiled with CFR 0.152.
 */
package aa.cache;

import aa.cache.UserAttributeCache;
import aa.model.UserAttribute;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.io.IOException;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public abstract class AbstractUserAttributeCache
implements UserAttributeCache {
    protected final Logger LOG = LoggerFactory.getLogger(this.getClass());
    private final long cacheDuration;
    private final boolean cacheInActive;

    public AbstractUserAttributeCache(long cacheDurationMilliseconds) {
        this.cacheDuration = cacheDurationMilliseconds;
        this.cacheInActive = cacheDurationMilliseconds <= 0L;
    }

    @Override
    public Optional<List<UserAttribute>> get(Optional<String> cacheKey) throws IOException {
        if (this.cacheInActive || !cacheKey.isPresent()) {
            return Optional.empty();
        }
        List<UserAttribute> userAttributes = this.doGet(cacheKey.get());
        this.LOG.debug("Returning userAttributes from cache {}", userAttributes);
        return userAttributes != null ? Optional.of(userAttributes) : Optional.empty();
    }

    protected abstract List<UserAttribute> doGet(String var1) throws IOException;

    @Override
    public void put(Optional<String> cacheKey, List<UserAttribute> userAttributes) throws IOException {
        if (!this.cacheInActive && cacheKey.isPresent() && !CollectionUtils.isEmpty(userAttributes)) {
            this.LOG.debug("Putting userAttributes in cache {} with key {}", userAttributes, (Object)cacheKey.get());
            this.doPut(cacheKey.get(), userAttributes);
        }
    }

    protected abstract void doPut(String var1, List<UserAttribute> var2) throws JsonProcessingException;

    public long getCacheDuration() {
        return this.cacheDuration;
    }
}

