/*
 * Decompiled with CFR 0.152.
 */
package aa.cache;

import aa.cache.AbstractUserAttributeCache;
import aa.model.UserAttribute;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.List;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.springframework.util.StringUtils;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPoolConfig;

public class RedisUserAttributeCache
extends AbstractUserAttributeCache {
    private final ObjectMapper objectMapper = new ObjectMapper();
    private final JedisPool pool;
    private TypeReference<List<UserAttribute>> typeRef = new TypeReference<List<UserAttribute>>(){};

    public RedisUserAttributeCache(String redisUrl, long cacheDuration) {
        super(cacheDuration);
        this.pool = new JedisPool((GenericObjectPoolConfig)new JedisPoolConfig(), redisUrl);
    }

    @Override
    protected List<UserAttribute> doGet(String cacheKey) throws IOException {
        try (Jedis jedis = this.pool.getResource();){
            String json = jedis.get(cacheKey);
            List list = StringUtils.hasText((String)json) ? (List)this.objectMapper.readValue(json, this.typeRef) : null;
            return list;
        }
    }

    @Override
    protected void doPut(String cacheKey, List<UserAttribute> userAttributes) throws JsonProcessingException {
        try (Jedis jedis = this.pool.getResource();){
            jedis.psetex(cacheKey, this.getCacheDuration(), this.objectMapper.writeValueAsString(userAttributes));
        }
    }
}

