/*
 * Decompiled with CFR 0.152.
 */
package aa.cache;

import aa.cache.AbstractUserAttributeCache;
import aa.model.UserAttribute;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;

public class SimpleInMemoryUserAttributeCache
extends AbstractUserAttributeCache {
    private final Map<String, CachedAggregate> cache = new ConcurrentHashMap<String, CachedAggregate>();

    public SimpleInMemoryUserAttributeCache(long cacheDurationMilliseconds, long clearExpiredAggregatesPeriod) {
        super(cacheDurationMilliseconds);
        if (cacheDurationMilliseconds > 0L) {
            Executors.newScheduledThreadPool(1).scheduleAtFixedRate(this::clearExpiredAggregates, 0L, clearExpiredAggregatesPeriod, TimeUnit.MILLISECONDS);
        }
    }

    @Override
    protected List<UserAttribute> doGet(String cacheKey) {
        CachedAggregate cachedAggregate = this.cache.get(cacheKey);
        long now = System.currentTimeMillis();
        if (cachedAggregate != null && cachedAggregate.timestamp + this.getCacheDuration() > now) {
            return cachedAggregate.aggregate;
        }
        return null;
    }

    @Override
    protected void doPut(String cacheKey, List<UserAttribute> userAttributes) {
        long now = System.currentTimeMillis();
        this.cache.put(cacheKey, new CachedAggregate(now, userAttributes));
    }

    private void clearExpiredAggregates() {
        long now = System.currentTimeMillis();
        long cacheDuration = this.getCacheDuration();
        this.cache.forEach((key, aggregate) -> {
            if (aggregate.timestamp + cacheDuration < now) {
                this.LOG.debug("Removing expired aggregation with key {}", key);
                this.cache.remove(key);
            }
        });
    }

    private class CachedAggregate {
        long timestamp;
        List<UserAttribute> aggregate;

        public CachedAggregate(long timestamp, List<UserAttribute> aggregate) {
            this.timestamp = timestamp;
            this.aggregate = aggregate;
        }
    }
}

