/*
 * Decompiled with CFR 0.152.
 */
package aa.cache;

import aa.cache.RedisUserAttributeCache;
import aa.cache.SimpleInMemoryUserAttributeCache;
import aa.cache.UserAttributeCache;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.context.annotation.Profile;

@Configuration
public class UserAttributeCacheConfiguration {
    @Bean
    @Profile(value={"!redis"})
    public UserAttributeCache inMemoryUserAttributeCache(@Value(value="${aggregate.cache.duration.milliseconds}") long cacheDuration) {
        return new SimpleInMemoryUserAttributeCache(cacheDuration, cacheDuration);
    }

    @Bean
    @Profile(value={"redis"})
    @Autowired
    @Primary
    public UserAttributeCache redisUserAttributeCache(@Value(value="${redis.url}") String redisUrl, @Value(value="${aggregate.cache.duration.milliseconds}") long cacheDuration) {
        return new RedisUserAttributeCache(redisUrl, cacheDuration);
    }
}

