/*
 * Decompiled with CFR 0.152.
 */
package aa.control;

import aa.config.AuthorityConfiguration;
import aa.config.AuthorityResolver;
import aa.model.Aggregation;
import aa.model.AggregationNotFoundException;
import aa.model.Attribute;
import aa.model.ServiceProvider;
import aa.repository.AggregationRepository;
import aa.repository.ServiceProviderRepository;
import aa.service.AggregationValidator;
import aa.serviceregistry.ServiceRegistry;
import aa.shibboleth.FederatedUser;
import aa.util.StreamUtils;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(headers={"Content-Type=application/json"}, produces={"application/json"})
public class InternalAggregationController {
    private static final Logger LOG = LoggerFactory.getLogger(InternalAggregationController.class);
    private final AggregationValidator aggregationValidator = new AggregationValidator();
    private final ServiceProviderRepository serviceProviderRepository;
    private final AggregationRepository aggregationRepository;
    private final AuthorityConfiguration configuration;
    private final ServiceRegistry serviceRegistry;

    @Autowired
    public InternalAggregationController(ServiceProviderRepository serviceProviderRepository, AggregationRepository aggregationRepository, AuthorityResolver authorityResolver, ServiceRegistry serviceRegistry) {
        this.serviceProviderRepository = serviceProviderRepository;
        this.aggregationRepository = aggregationRepository;
        this.configuration = authorityResolver.getConfiguration();
        this.serviceRegistry = serviceRegistry;
    }

    @RequestMapping(method={RequestMethod.POST}, value={"/internal/aggregation"})
    public Aggregation saveAggregation(@RequestBody Aggregation aggregation) {
        this.aggregationValidator.validate(this.configuration, this.serviceRegistry, aggregation);
        aggregation.setServiceProviders(aggregation.getServiceProviders().stream().map(this::serviceProviderOrExists).collect(Collectors.toSet()));
        aggregation.setAttributes(new HashSet<Attribute>(aggregation.getAttributes()));
        FederatedUser federatedUser = this.federatedUser();
        aggregation.setUserDisplayName(federatedUser.getDisplayName());
        aggregation.setUserIdentifier(federatedUser.getUid());
        Aggregation saved = (Aggregation)this.aggregationRepository.save(aggregation);
        LOG.debug("Saved aggregation {}", (Object)saved);
        return saved;
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/internal/aggregation/{id}"})
    public Aggregation getAggregation(@PathVariable Long id) {
        Aggregation aggregation = (Aggregation)this.aggregationRepository.findOne(id);
        if (aggregation == null) {
            throw new AggregationNotFoundException("Aggregation with id " + id + " not found");
        }
        aggregation.getServiceProviders().forEach(this::addMetaDataInformation);
        LOG.debug("Returning one aggregation {}", (Object)aggregation);
        return aggregation;
    }

    @RequestMapping(method={RequestMethod.PUT}, value={"/internal/aggregation"})
    public Aggregation updateAggregation(@RequestBody Aggregation aggregation) {
        Aggregation saved = this.saveAggregation(aggregation);
        this.serviceProviderRepository.deleteOrphanedServiceProviders();
        return saved;
    }

    @RequestMapping(method={RequestMethod.DELETE}, value={"/internal/aggregation/{id}"})
    public Aggregation deleteAggregation(@PathVariable Long id) {
        Aggregation aggregation = (Aggregation)this.aggregationRepository.findOne(id);
        this.aggregationRepository.delete(aggregation);
        LOG.debug("Deleted Aggregation with ID {}", (Object)id);
        int deleted = this.serviceProviderRepository.deleteOrphanedServiceProviders();
        LOG.debug("Deleted {} orphaned ServiceProviders", (Object)deleted);
        return aggregation;
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/internal/aggregations"})
    public List<Aggregation> aggregations() {
        List<Aggregation> aggregations = StreamUtils.listFromIterable(this.aggregationRepository.findAll());
        aggregations.forEach(aggregation -> aggregation.getServiceProviders().forEach(this::addMetaDataInformation));
        LOG.debug("Returning all aggregations {}", aggregations);
        return aggregations;
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/internal/aggregationExistsByName"})
    public boolean aggregationExistsByName(@RequestParam(value="name") String name, @RequestParam(value="id", required=false) Long id) {
        return id == null ? this.aggregationRepository.existsByName(name) : this.aggregationRepository.existsByNameAndId(name, id);
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/internal/aggregationsByServiceProviderEntityIds"})
    public List<Object[]> aggregationsByServiceProviderEntityIds(@RequestParam(value="entityIds") String[] entityIds, @RequestParam(value="aggregationId", required=false) Long aggregationId) {
        return this.aggregationRepository.getAggregationsByServiceProviderEntityIds(Arrays.asList(entityIds), aggregationId == null ? -1L : aggregationId);
    }

    private void addMetaDataInformation(ServiceProvider serviceProvider) {
        Optional<ServiceProvider> optional = this.serviceRegistry.serviceProviderByEntityId(serviceProvider.getEntityId());
        if (optional.isPresent()) {
            ServiceProvider sp = optional.get();
            serviceProvider.setName(sp.getName());
            serviceProvider.setDescription(sp.getDescription());
        }
    }

    private ServiceProvider serviceProviderOrExists(ServiceProvider serviceProvider) {
        return this.serviceProviderRepository.findByEntityId(serviceProvider.getEntityId()).orElse(serviceProvider);
    }

    private FederatedUser federatedUser() {
        Object principal = SecurityContextHolder.getContext().getAuthentication().getPrincipal();
        Assert.isInstanceOf(FederatedUser.class, (Object)principal);
        return (FederatedUser)((Object)principal);
    }
}

