/*
 * Decompiled with CFR 0.152.
 */
package aa.oauth;

import aa.model.UserAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.util.StringUtils;

public class FederatedUserAuthenticationToken
extends UsernamePasswordAuthenticationToken {
    private final String schacHomeOrganization;
    private final String eduPersonPrincipalName;

    public FederatedUserAuthenticationToken(String eduPersonPrincipalName, String schacHomeOrganization, Object principal, Object credentials, Collection<? extends GrantedAuthority> authorities) {
        super(principal, credentials, authorities);
        this.eduPersonPrincipalName = eduPersonPrincipalName;
        this.schacHomeOrganization = schacHomeOrganization;
    }

    public String getEduPersonPrincipalName() {
        return this.eduPersonPrincipalName;
    }

    public String getSchacHomeOrganization() {
        return this.schacHomeOrganization;
    }

    public List<UserAttribute> getUserAttributes() {
        ArrayList<UserAttribute> input = new ArrayList<UserAttribute>(Arrays.asList(new UserAttribute("urn:oasis:names:tc:SAML:1.1:nameid-format:unspecified", Collections.singletonList(this.getName())), new UserAttribute("urn:mace:terena.org:attribute-def:schacHomeOrganization", Collections.singletonList(this.schacHomeOrganization))));
        if (StringUtils.hasText((String)this.eduPersonPrincipalName)) {
            input.add(new UserAttribute("urn:mace:dir:attribute-def:eduPersonPrincipalName", Collections.singletonList(this.eduPersonPrincipalName)));
        }
        return input;
    }
}

