/*
 * Decompiled with CFR 0.152.
 */
package aa.oidc;

import aa.oauth.DecisionResourceServerTokenServices;
import aa.oidc.OidcSchacHomeAwareUserAuthenticationConverter;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.crypto.codec.Base64;
import org.springframework.security.oauth2.common.DefaultOAuth2AccessToken;
import org.springframework.security.oauth2.common.OAuth2AccessToken;
import org.springframework.security.oauth2.common.exceptions.InvalidTokenException;
import org.springframework.security.oauth2.provider.OAuth2Authentication;
import org.springframework.security.oauth2.provider.token.AccessTokenConverter;
import org.springframework.security.oauth2.provider.token.DefaultAccessTokenConverter;
import org.springframework.security.oauth2.provider.token.UserAuthenticationConverter;
import org.springframework.util.Assert;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.UriComponentsBuilder;

public class OidcRemoteTokenServices
implements DecisionResourceServerTokenServices {
    private static Logger LOG = LoggerFactory.getLogger(OidcRemoteTokenServices.class);
    private String checkTokenEndpointUrl;
    private String clientId;
    private String clientSecret;
    private AccessTokenConverter accessTokenConverter;
    private RestTemplate restTemplate;

    public OidcRemoteTokenServices(String checkTokenEndpointUrl, String clientId, String clientSecret) {
        this.checkTokenEndpointUrl = checkTokenEndpointUrl;
        this.clientId = clientId;
        this.clientSecret = clientSecret;
        this.restTemplate = new RestTemplate();
        this.accessTokenConverter = new DefaultAccessTokenConverter();
        ((DefaultAccessTokenConverter)this.accessTokenConverter).setUserTokenConverter((UserAuthenticationConverter)new OidcSchacHomeAwareUserAuthenticationConverter());
    }

    public OAuth2Authentication loadAuthentication(String accessToken) throws AuthenticationException, InvalidTokenException {
        Object scope;
        HttpEntity entity;
        String introspectUri = UriComponentsBuilder.fromHttpUrl((String)this.checkTokenEndpointUrl).queryParam("token", new Object[]{accessToken}).build().toUriString();
        Map map = (Map)this.restTemplate.exchange(introspectUri, HttpMethod.GET, entity = new HttpEntity(this.headersForIntrospection()), Map.class, new Object[0]).getBody();
        if (map.containsKey("error")) {
            LOG.warn("introspect returned error: " + map.get("error"));
            throw new InvalidTokenException(accessToken);
        }
        if (!map.containsKey("active") || !((Boolean)map.get("active")).booleanValue()) {
            LOG.warn("introspect returned inactive access_token: " + accessToken);
            throw new InvalidTokenException(accessToken);
        }
        Assert.state((boolean)map.containsKey("client_id"), (String)"Client id must be present in response from auth server");
        if (map.containsKey("scope") && (scope = map.get("scope")) instanceof String) {
            map.put("scope", Arrays.asList(((String)scope).split(" ")));
        }
        return this.accessTokenConverter.extractAuthentication(map);
    }

    public OAuth2AccessToken readAccessToken(String accessToken) {
        return new DefaultOAuth2AccessToken(accessToken);
    }

    public void setRestTemplate(RestTemplate restTemplate) {
        this.restTemplate = restTemplate;
    }

    private MultiValueMap<String, String> headersForIntrospection() {
        HttpHeaders headers = new HttpHeaders();
        String basicAuthz = this.clientId + ":" + this.clientSecret;
        String authenticationCredentials = "Basic " + new String(Base64.encode((byte[])basicAuthz.getBytes(Charset.forName("UTF-8"))));
        headers.add("Authorization", authenticationCredentials);
        headers.add("Accept", "application/json");
        return headers;
    }

    @Override
    public boolean canHandle(String accessToken) {
        return !uuidPattern.matcher(accessToken).matches();
    }
}

