/*
 * Decompiled with CFR 0.152.
 */
package aa.serviceregistry;

import aa.model.ServiceProvider;
import aa.serviceregistry.ServiceRegistry;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.util.StringUtils;

public class ClassPathResourceServiceRegistry
implements ServiceRegistry {
    protected final Logger LOG = LoggerFactory.getLogger(this.getClass());
    private static final ObjectMapper objectMapper = new ObjectMapper();
    private Map<String, ServiceProvider> entityMetaData = new ConcurrentHashMap<String, ServiceProvider>();

    public ClassPathResourceServiceRegistry(boolean initialize) throws IOException {
        if (initialize) {
            this.initializeMetadata();
        }
    }

    protected void initializeMetadata() {
        long start = System.currentTimeMillis();
        this.LOG.debug("Starting refreshing SP metadata.");
        ConcurrentHashMap<String, ServiceProvider> newEntityMetaData = new ConcurrentHashMap<String, ServiceProvider>();
        List<Resource> resources = this.getResources();
        Map<String, ServiceProvider> serviceProviderMap = resources.stream().map(this::parseEntities).flatMap(m -> m.entrySet().stream()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        newEntityMetaData.putAll(serviceProviderMap);
        this.entityMetaData = newEntityMetaData;
        this.LOG.debug("Finished refreshing SP metadata in {} ms.", (Object)(System.currentTimeMillis() - start));
    }

    protected List<Resource> getResources() {
        return Collections.singletonList(new ClassPathResource("service-registry/service-providers.json"));
    }

    @Override
    public Collection<ServiceProvider> serviceProviders() {
        return this.entityMetaData.values();
    }

    @Override
    public Optional<ServiceProvider> serviceProviderByEntityId(String entityId) {
        ServiceProvider sp = this.entityMetaData.get(entityId);
        return sp == null ? Optional.empty() : Optional.of(sp);
    }

    protected Map<String, ServiceProvider> parseEntities(Resource resource) {
        List<Map<String, Object>> list = this.readValue(resource);
        return list.stream().map(entry -> new ServiceProvider((String)entry.get("entityid"), this.getMetaDateEntry((Map<String, Object>)entry, "description"), this.getMetaDateEntry((Map<String, Object>)entry, "name"), this.getAttributeAggregationRequired((Map<String, Object>)entry))).sorted(this.sortEntityMetaData()).collect(Collectors.toMap(ServiceProvider::getEntityId, e -> e));
    }

    private boolean getAttributeAggregationRequired(Map<String, Object> entry) {
        String attributeAggregationRequired = (String)entry.get("coin:attribute_aggregation_required");
        return StringUtils.hasText((String)attributeAggregationRequired) && attributeAggregationRequired.equals("1");
    }

    private List<Map<String, Object>> readValue(Resource resource) {
        try {
            return (List)objectMapper.readValue(resource.getInputStream(), List.class);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private Comparator<? super ServiceProvider> sortEntityMetaData() {
        return (e1, e2) -> this.getServiceProviderComparatorId((ServiceProvider)e1).compareTo(this.getServiceProviderComparatorId((ServiceProvider)e2));
    }

    private String getServiceProviderComparatorId(ServiceProvider sp) {
        return sp.getName() != null ? sp.getName() : (sp.getDescription() != null ? sp.getDescription() : sp.getEntityId());
    }

    private String getMetaDateEntry(Map<String, Object> entry, String attributeName) {
        String attribute = (String)entry.get(attributeName + ":en");
        if (!StringUtils.hasText((String)attribute) && !StringUtils.hasText((String)(attribute = (String)entry.get(attributeName + ":nl")))) {
            attribute = (String)entry.get("entityid");
        }
        return attribute;
    }
}

