/*
 * Decompiled with CFR 0.152.
 */
package access.security;

import access.exception.UserRestrictionException;
import access.model.Authority;
import access.model.Role;
import access.model.User;
import access.model.UserRole;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.util.StringUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class UserPermissions {
    private UserPermissions() {
    }

    public static void assertSuperUser(User user) {
        if (!user.isSuperUser()) {
            throw new UserRestrictionException();
        }
    }

    public static void assertInstitutionAdmin(User user) {
        if (user.isSuperUser() || user.isInstitutionAdmin() && StringUtils.hasText((String)user.getOrganizationGUID())) {
            return;
        }
        throw new UserRestrictionException();
    }

    public static void assertAuthority(User user, Authority authority) {
        if (user.isInstitutionAdmin() && Authority.INSTITUTION_ADMIN.hasEqualOrHigherRights(authority)) {
            return;
        }
        if (!user.isSuperUser() && user.getUserRoles().stream().noneMatch(userRole -> userRole.getAuthority().hasEqualOrHigherRights(authority))) {
            throw new UserRestrictionException();
        }
    }

    public static void assertValidInvitation(User user, Authority intendedAuthority, List<Role> roles) {
        if (user.isSuperUser()) {
            return;
        }
        if (intendedAuthority.equals((Object)Authority.SUPER_USER)) {
            throw new UserRestrictionException();
        }
        Set userRoles = user.getUserRoles();
        if (user.isInstitutionAdmin() && roles.stream().allMatch(role -> UserPermissions.mayInviteByInstitutionAdmin((List)user.getApplications(), (List)role.applicationIdentifiers()))) {
            return;
        }
        boolean allowed = roles.stream().allMatch(role -> UserPermissions.mayInviteByApplication((Set)userRoles, (Authority)intendedAuthority, (Role)role) || UserPermissions.mayInviteByAuthority((Set)userRoles, (Authority)intendedAuthority, (Role)role));
        if (!allowed) {
            throw new UserRestrictionException();
        }
    }

    private static boolean mayInviteByApplication(Set<UserRole> userRoles, Authority intendedAuthority, Role role) {
        return userRoles.stream().anyMatch(userRole -> userRole.hasAccessToApplication(role) && userRole.getAuthority().hasEqualOrHigherRights(Authority.MANAGER) && userRole.getAuthority().hasEqualOrHigherRights(intendedAuthority));
    }

    private static boolean mayInviteByInstitutionAdmin(List<Map<String, Object>> applications, List<String> manageIdentifiers) {
        return applications.stream().anyMatch(application -> manageIdentifiers.contains(application.get("id")));
    }

    private static boolean mayInviteByAuthority(Set<UserRole> userRoles, Authority intendedAuthority, Role role) {
        return userRoles.stream().anyMatch(userRole -> userRole.getAuthority().hasHigherRights(intendedAuthority) && userRole.getAuthority().hasEqualOrHigherRights(Authority.INVITER) && userRole.getRole().getId().equals(role.getId()));
    }

    public static void assertManagerRole(List<String> manageIdentifiers, User user) {
        if (user.isSuperUser()) {
            return;
        }
        if (user.isInstitutionAdmin() && UserPermissions.mayInviteByInstitutionAdmin((List)user.getApplications(), manageIdentifiers)) {
            return;
        }
        user.getUserRoles().stream().filter(userRole -> {
            if (!userRole.getAuthority().hasEqualOrHigherRights(Authority.MANAGER)) return false;
            if (!userRole.getRole().applicationIdentifiers().stream().anyMatch(manageIdentifiers::contains)) return false;
            return true;
        }).findFirst().orElseThrow(UserRestrictionException::new);
    }

    public static void assertRoleAccess(User user, Role accessRole) {
        UserPermissions.assertRoleAccess((User)user, (Role)accessRole, (Authority)Authority.MANAGER);
    }

    public static void assertRoleAccess(User user, Role accessRole, Authority authority) {
        if (user.isSuperUser()) {
            return;
        }
        if (user.isInstitutionAdmin() && UserPermissions.mayInviteByInstitutionAdmin((List)user.getApplications(), (List)accessRole.applicationIdentifiers())) {
            return;
        }
        user.getUserRoles().stream().filter(userRole -> userRole.getRole().getId().equals(accessRole.getId()) && userRole.getAuthority().hasEqualOrHigherRights(authority) || userRole.hasAccessToApplication(accessRole) && userRole.getAuthority().hasEqualOrHigherRights(Authority.MANAGER)).findFirst().orElseThrow(UserRestrictionException::new);
    }
}

