/*
 * Decompiled with CFR 0.152.
 */
package access.config;

import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.security.SecureRandom;
import java.util.Base64;
import java.util.Random;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.RandomStringUtils;

public class HashGenerator {
    private static final Random secureRandom = new SecureRandom();

    private HashGenerator() {
    }

    public static String generateHash() {
        byte[] aesKey = new byte[128];
        secureRandom.nextBytes(aesKey);
        String base64 = Base64.getEncoder().encodeToString(aesKey);
        return URLEncoder.encode(base64, StandardCharsets.UTF_8).replaceAll("%", "");
    }

    public static String generateToken() {
        return RandomStringUtils.random((int)36, (boolean)true, (boolean)true);
    }

    public static String hashToken(String token) {
        return new DigestUtils("SHA3-256").digestAsHex(token);
    }
}

