/*
 * Decompiled with CFR 0.152.
 */
package access.manage;

import access.exception.NotFoundException;
import access.manage.EntityType;
import access.manage.Manage;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.core.io.ClassPathResource;
import org.springframework.util.CollectionUtils;

public final class LocalManage
implements Manage {
    private final Map<EntityType, List<Map<String, Object>>> allProviders;
    private final boolean local;

    public LocalManage(ObjectMapper objectMapper, boolean local) {
        this.local = local;
        this.allProviders = Stream.of(EntityType.values()).collect(Collectors.toMap(entityType -> entityType, entityType -> this.initialize(objectMapper, entityType)));
    }

    private List<Map<String, Object>> initialize(ObjectMapper objectMapper, EntityType entityType) {
        Object collectionName = entityType.collectionName();
        if (this.local && ((String)collectionName).equals(EntityType.PROVISIONING.collectionName())) {
            collectionName = (String)collectionName + ".local";
        }
        return (List)objectMapper.readValue(new ClassPathResource("/manage/" + (String)collectionName + ".json").getInputStream(), (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
    }

    public List<Map<String, Object>> providers(EntityType ... entityTypes) {
        return this.transformProvider(Stream.of(entityTypes).map(entityType -> ((List)this.allProviders.get(entityType)).stream().toList()).flatMap(Collection::stream).toList());
    }

    public List<Map<String, Object>> providersByIdIn(EntityType entityType, List<String> identifiers) {
        List providers = (List)this.allProviders.get(entityType);
        return this.transformProvider(providers.stream().filter(provider -> identifiers.contains(provider.get("_id"))).collect(Collectors.toList()));
    }

    public Optional<Map<String, Object>> providerByEntityID(EntityType entityType, String entityID) {
        return ((List)this.allProviders.get(entityType)).stream().filter(provider -> entityID.equals(((Map)provider.get("data")).get("entityid"))).map(arg_0 -> ((LocalManage)this).transformProvider(arg_0)).findFirst();
    }

    public Map<String, Object> providerById(EntityType entityType, String id) {
        List providers = this.providers(new EntityType[]{entityType});
        return providers.stream().filter(provider -> provider.get("_id").equals(id)).findFirst().orElseThrow(NotFoundException::new);
    }

    public List<Map<String, Object>> provisioning(Collection<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return Collections.emptyList();
        }
        return this.providers(new EntityType[]{EntityType.PROVISIONING}).stream().filter(map -> {
            List applications = (List)map.get("applications");
            return applications.stream().anyMatch(m -> ids.contains(m.get("id")));
        }).collect(Collectors.toList());
    }

    public List<Map<String, Object>> providersByInstitutionalGUID(String organisationGUID) {
        List providers = this.providers(new EntityType[]{EntityType.SAML20_SP, EntityType.OIDC10_RP});
        return providers.stream().filter(provider -> Objects.equals(provider.get("institutionGuid"), organisationGUID)).toList();
    }

    public Optional<Map<String, Object>> identityProviderByInstitutionalGUID(String organisationGUID) {
        List providers = this.providers(new EntityType[]{EntityType.SAML20_IDP});
        return providers.stream().filter(provider -> Objects.equals(provider.get("institutionGuid"), organisationGUID)).findAny();
    }
}

