/*
 * Decompiled with CFR 0.152.
 */
package access.model;

import access.model.Authority;
import access.model.Role;
import access.model.User;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.FetchType;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.Transient;
import jakarta.validation.constraints.NotNull;
import java.io.Serializable;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Map;
import java.util.Set;

@Entity(name="user_roles")
public class UserRole
implements Serializable {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private Long id;
    @Column(name="inviter")
    private String inviter;
    @Column(name="end_date")
    private Instant endDate;
    @Column(name="created_at")
    private Instant createdAt;
    @Column(name="expiry_notifications")
    private int expiryNotifications;
    @Column(name="guest_role_included")
    private boolean guestRoleIncluded;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="user_id")
    @JsonProperty(access=JsonProperty.Access.WRITE_ONLY)
    private User user;
    @ManyToOne(fetch=FetchType.EAGER)
    @JoinColumn(name="role_id")
    private Role role;
    @Enumerated(value=EnumType.STRING)
    @Column
    @NotNull
    private Authority authority = Authority.GUEST;
    @Transient
    private Map<String, Object> userInfo;

    public UserRole(Authority authority, Role role) {
        this(null, null, role, authority);
    }

    public UserRole(String inviter, User user, Role role, Authority authority) {
        this(inviter, user, role, authority, false, null);
    }

    public UserRole(String inviter, User user, Role role, @NotNull Authority authority, boolean guestRoleIncluded, Instant endDate) {
        this.inviter = inviter;
        this.user = user;
        this.role = role;
        this.authority = authority;
        this.guestRoleIncluded = guestRoleIncluded;
        this.endDate = endDate == null && authority.equals((Object)Authority.GUEST) ? Instant.now().plus((long)role.getDefaultExpiryDays().intValue(), ChronoUnit.DAYS) : endDate;
        this.createdAt = Instant.now();
    }

    @Transient
    @JsonIgnore
    public boolean hasAccessToApplication(Role otherRole) {
        Set mineApplications = this.role.applicationsUsed();
        Set otherApplications = otherRole.applicationsUsed();
        return mineApplications.stream().anyMatch(application -> otherApplications.stream().anyMatch(otherApplication -> otherApplication.getManageId().equals(application.getManageId())));
    }

    public UserRole() {
    }

    public Long getId() {
        return this.id;
    }

    public String getInviter() {
        return this.inviter;
    }

    public Instant getEndDate() {
        return this.endDate;
    }

    public Instant getCreatedAt() {
        return this.createdAt;
    }

    public int getExpiryNotifications() {
        return this.expiryNotifications;
    }

    public boolean isGuestRoleIncluded() {
        return this.guestRoleIncluded;
    }

    public User getUser() {
        return this.user;
    }

    public Role getRole() {
        return this.role;
    }

    public Authority getAuthority() {
        return this.authority;
    }

    public Map<String, Object> getUserInfo() {
        return this.userInfo;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setInviter(String inviter) {
        this.inviter = inviter;
    }

    public void setEndDate(Instant endDate) {
        this.endDate = endDate;
    }

    public void setCreatedAt(Instant createdAt) {
        this.createdAt = createdAt;
    }

    public void setExpiryNotifications(int expiryNotifications) {
        this.expiryNotifications = expiryNotifications;
    }

    public void setGuestRoleIncluded(boolean guestRoleIncluded) {
        this.guestRoleIncluded = guestRoleIncluded;
    }

    @JsonProperty(access=JsonProperty.Access.WRITE_ONLY)
    public void setUser(User user) {
        this.user = user;
    }

    public void setRole(Role role) {
        this.role = role;
    }

    public void setAuthority(Authority authority) {
        this.authority = authority;
    }

    public void setUserInfo(Map<String, Object> userInfo) {
        this.userInfo = userInfo;
    }
}

