/*
 * Decompiled with CFR 0.152.
 */
package access.provision.graph;

import access.exception.RemoteException;
import access.provision.Provisioning;
import access.provision.graph.GraphResponse;
import com.azure.core.credential.TokenCredential;
import com.azure.identity.ClientSecretCredential;
import com.azure.identity.ClientSecretCredentialBuilder;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.microsoft.graph.authentication.IAuthenticationProvider;
import com.microsoft.graph.authentication.TokenCredentialAuthProvider;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.models.Invitation;
import com.microsoft.graph.models.User;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.requests.GraphServiceClient;
import com.microsoft.graph.requests.InvitationCollectionRequest;
import com.microsoft.graph.requests.UserRequest;
import crypto.KeyStore;
import java.io.IOException;
import java.lang.reflect.Field;
import okhttp3.Request;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.http.HttpStatus;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class GraphClient {
    private static final Log LOG = LogFactory.getLog(GraphClient.class);
    private final String serverUrl;
    private final String eduidIdpSchacHomeOrganization;
    private final KeyStore keyStore;
    private final ObjectMapper objectMapper;

    public GraphClient(String serverUrl, String eduidIdpSchacHomeOrganization, KeyStore keyStore, ObjectMapper objectMapper) {
        this.serverUrl = serverUrl;
        this.eduidIdpSchacHomeOrganization = eduidIdpSchacHomeOrganization;
        this.keyStore = keyStore;
        this.objectMapper = objectMapper;
    }

    public GraphResponse newUserRequest(Provisioning provisioning, access.model.User user) {
        GraphServiceClient graphServiceClient = this.getRequestGraphServiceClient(provisioning);
        InvitationCollectionRequest buildRequest = (InvitationCollectionRequest)graphServiceClient.invitations().buildRequest(new Option[0]);
        String graphUrl = provisioning.getGraphUrl();
        graphUrl = GraphClient.replaceGraphUrl((String)graphUrl, (BaseRequest)buildRequest.getBaseRequest());
        Invitation invitation = new Invitation();
        invitation.invitedUserEmailAddress = this.eduidIdpSchacHomeOrganization.equalsIgnoreCase(user.getSchacHomeOrganization()) ? user.getEduPersonPrincipalName() : user.getEmail();
        invitation.invitedUserDisplayName = user.getName();
        invitation.inviteRedirectUrl = String.format("%s/api/v1/invitations/ms-accept-return/%s/%s", this.serverUrl, provisioning.getId(), user.getId());
        invitation.sendInvitationMessage = false;
        invitation.invitedUserType = "Guest";
        LOG.info((Object)String.format("Send CreateUser Graph request to %s for provisioning %s for user %s", buildRequest.getBaseRequest().getRequestUrl(), provisioning.getGraphClientId(), user.getEduPersonPrincipalName()));
        try {
            Invitation newInvitation = buildRequest.post(invitation);
            String invitationJson = this.objectMapper.writeValueAsString((Object)newInvitation);
            LOG.info((Object)String.format("Response from graph endpoint for user %s, inviteRedeemUrl: %s, json: %s", user.getEmail(), newInvitation.inviteRedeemUrl, invitationJson));
            return new GraphResponse(newInvitation.invitedUser.id, newInvitation.inviteRedeemUrl);
        }
        catch (ClientException | IOException e) {
            String errorMessage = String.format("Error Graph request (entityID %s) to %s for user %s", provisioning.getEntityId(), graphUrl, user.getEmail());
            throw new RemoteException(HttpStatus.BAD_REQUEST, errorMessage, e);
        }
    }

    public void updateUserRequest(access.model.User user, Provisioning provisioning, String remoteUserIdentifier) {
        GraphServiceClient graphServiceClient = this.getRequestGraphServiceClient(provisioning);
        UserRequest userRequest = graphServiceClient.users(remoteUserIdentifier).buildRequest(new Option[0]);
        String graphUrl = provisioning.getGraphUrl();
        GraphClient.replaceGraphUrl((String)graphUrl, (BaseRequest)userRequest);
        try {
            User graphUser = userRequest.get();
            graphUser.mail = user.getEmail();
            userRequest.patch(graphUser);
        }
        catch (ClientException e) {
            String errorMessage = String.format("Error Graph request (entityID %s) to %s for user %s", provisioning.getEntityId(), graphUrl, user.getEmail());
            throw new RemoteException(HttpStatus.BAD_REQUEST, errorMessage, (Throwable)e);
        }
    }

    public void deleteUser(access.model.User user, Provisioning provisioning, String remoteUserIdentifier) {
        GraphServiceClient graphServiceClient = this.getRequestGraphServiceClient(provisioning);
        UserRequest userRequest = graphServiceClient.users(remoteUserIdentifier).buildRequest(new Option[0]);
        String graphUrl = provisioning.getGraphUrl();
        GraphClient.replaceGraphUrl((String)graphUrl, (BaseRequest)userRequest);
        try {
            userRequest.delete();
        }
        catch (ClientException e) {
            String errorMessage = String.format("Error Graph delete (entityID %s) to %s for user %s", provisioning.getEntityId(), graphUrl, user.getEmail());
            throw new RemoteException(HttpStatus.BAD_REQUEST, errorMessage, (Throwable)e);
        }
    }

    private GraphServiceClient<Request> getRequestGraphServiceClient(Provisioning provisioning) {
        String encryptedGraphSecret = provisioning.getGraphSecret();
        String graphSecret = this.keyStore.isEncryptedSecret(encryptedGraphSecret) ? this.keyStore.decodeAndDecrypt(encryptedGraphSecret) : encryptedGraphSecret;
        ClientSecretCredential credential = ((ClientSecretCredentialBuilder)((ClientSecretCredentialBuilder)new ClientSecretCredentialBuilder().clientId(provisioning.getGraphClientId())).tenantId(provisioning.getGraphTenant())).clientSecret(graphSecret).build();
        TokenCredentialAuthProvider authProvider = new TokenCredentialAuthProvider((TokenCredential)credential);
        GraphServiceClient graphClient = GraphServiceClient.builder().authenticationProvider((IAuthenticationProvider)authProvider).buildClient();
        return graphClient;
    }

    private static String replaceGraphUrl(String graphUrl, BaseRequest buildRequest) {
        if (StringUtils.hasText((String)graphUrl) && (graphUrl.startsWith("http://") || graphUrl.contains("mock"))) {
            Field field = ReflectionUtils.findField(BaseRequest.class, (String)"requestUrl");
            ReflectionUtils.makeAccessible((Field)field);
            ReflectionUtils.setField((Field)field, (Object)buildRequest, (Object)graphUrl);
            return graphUrl;
        }
        return "https://graph.microsoft.com/v1.0/";
    }
}

