/*
 * Decompiled with CFR 0.152.
 */
package access.voot;

import access.model.Authority;
import access.model.Role;
import access.model.User;
import access.model.UserRole;
import access.provision.scim.GroupURN;
import access.repository.UserRepository;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import java.time.Instant;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/voot", "/api/external/v1/voot"}, produces={"application/json"})
@SecurityRequirement(name="voot")
public class VootController {
    private static final Log LOG = LogFactory.getLog(VootController.class);
    private final UserRepository userRepository;
    private final String groupUrnPrefix;

    public VootController(UserRepository userRepository, @Value(value="${voot.group_urn_domain}") String groupUrnPrefix) {
        this.userRepository = userRepository;
        this.groupUrnPrefix = groupUrnPrefix;
    }

    @GetMapping(value={"/{unspecified_id}"})
    @PreAuthorize(value="hasRole('VOOT')")
    public ResponseEntity<List<Map<String, String>>> getGroupMemberships(@PathVariable(value="unspecified_id") String unspecifiedId) {
        Optional optionalUser = this.userRepository.findBySubIgnoreCase(unspecifiedId);
        if (optionalUser.isPresent()) {
            User user = (User)optionalUser.get();
            user.setLastActivity(Instant.now());
            this.userRepository.save((Object)user);
            List roles = user.getUserRoles().stream().filter(userRole -> userRole.getAuthority().equals((Object)Authority.GUEST) || userRole.isGuestRoleIncluded()).map(arg_0 -> this.parseUserRole(arg_0)).collect(Collectors.toList());
            LOG.debug((Object)String.format("Returning %o roles for VOOT request for user: %s", roles.size(), unspecifiedId));
            return ResponseEntity.ok(roles);
        }
        LOG.debug((Object)String.format("VOOT request for unknown user: %s", unspecifiedId));
        return ResponseEntity.ok(Collections.emptyList());
    }

    private Map<String, String> parseUserRole(UserRole userRole) {
        HashMap<String, String> res = new HashMap<String, String>();
        Role role = userRole.getRole();
        String urn = role.isTeamsOrigin() ? role.getUrn() : GroupURN.urnFromRole((String)this.groupUrnPrefix, (Role)role);
        res.put("urn", urn);
        res.put("name", role.getName());
        return res;
    }
}

