/*
 * Decompiled with CFR 0.152.
 */
package access.aggregation;

import access.manage.EntityType;
import access.manage.Manage;
import access.model.Authority;
import access.model.Role;
import access.model.User;
import access.model.UserRole;
import access.provision.scim.GroupURN;
import access.repository.UserRepository;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import java.time.Instant;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/aa", "/api/external/v1/aa"}, produces={"application/json"})
@SecurityRequirement(name="attributeAggregation")
public class AttributeAggregatorController {
    private static final Log LOG = LogFactory.getLog(AttributeAggregatorController.class);
    private final UserRepository userRepository;
    private final Manage manage;
    private final String groupUrnPrefix;

    public AttributeAggregatorController(UserRepository userRepository, Manage manage, @Value(value="${voot.group_urn_domain}") String groupUrnPrefix) {
        this.userRepository = userRepository;
        this.manage = manage;
        this.groupUrnPrefix = groupUrnPrefix;
    }

    @GetMapping(value={"/{unspecified_id}"})
    @PreAuthorize(value="hasRole('ATTRIBUTE_AGGREGATION')")
    public ResponseEntity<List<Map<String, String>>> getGroupMemberships(@PathVariable(value="unspecified_id") String unspecifiedId, @RequestParam(value="SPentityID") String spEntityId) {
        Optional optionalProvider;
        try {
            optionalProvider = this.manage.providerByEntityID(EntityType.SAML20_SP, spEntityId).or(() -> this.manage.providerByEntityID(EntityType.OIDC10_RP, spEntityId));
        }
        catch (RuntimeException e) {
            LOG.error((Object)"Error in communication with Manage", (Throwable)e);
            optionalProvider = Optional.empty();
        }
        if (optionalProvider.isEmpty()) {
            LOG.debug((Object)String.format("AA request for unknown service: %s", spEntityId));
            return ResponseEntity.ok(Collections.emptyList());
        }
        Optional optionalUser = this.userRepository.findBySubIgnoreCase(unspecifiedId);
        if (optionalUser.isEmpty()) {
            LOG.debug((Object)String.format("AA request for unknown user: %s", unspecifiedId));
            return ResponseEntity.ok(Collections.emptyList());
        }
        User user = (User)optionalUser.get();
        user.setLastActivity(Instant.now());
        this.userRepository.save((Object)user);
        Map provider = (Map)optionalProvider.get();
        List<Map> userRoles = user.getUserRoles().stream().filter(userRole -> userRole.getRole().applicationsUsed().stream().anyMatch(application -> application.getManageId().equals(provider.get("id")))).filter(userRole -> userRole.getAuthority().equals((Object)Authority.GUEST) || userRole.isGuestRoleIncluded()).map(arg_0 -> this.parseUserRole(arg_0)).toList();
        LOG.debug((Object)String.format("Returning %o roles for AA request for user: %s and service %s", userRoles.size(), unspecifiedId, spEntityId));
        return ResponseEntity.ok(userRoles);
    }

    private Map<String, String> parseUserRole(UserRole userRole) {
        Role role = userRole.getRole();
        String urn = role.isTeamsOrigin() ? role.getUrn() : GroupURN.urnFromRole((String)this.groupUrnPrefix, (Role)role);
        return Map.of("id", urn);
    }
}

