/*
 * Decompiled with CFR 0.152.
 */
package access.api;

import access.api.Results;
import access.config.HashGenerator;
import access.exception.NotFoundException;
import access.exception.UserRestrictionException;
import access.model.APIToken;
import access.model.User;
import access.repository.APITokenRepository;
import access.security.UserPermissions;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import io.swagger.v3.oas.annotations.security.SecurityRequirements;
import jakarta.servlet.http.HttpServletRequest;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/v1/tokens", "/api/external/v1/tokens"}, produces={"application/json"})
@Transactional
@SecurityRequirements(value={@SecurityRequirement(name="openId", scopes={"openid"}), @SecurityRequirement(name="apiTokens")})
public class APITokenController {
    private static final Log LOG = LogFactory.getLog(APITokenController.class);
    private static final String TOKEN_KEY = "token_key";
    private final APITokenRepository apiTokenRepository;

    public APITokenController(APITokenRepository apiTokenRepository) {
        this.apiTokenRepository = apiTokenRepository;
    }

    @GetMapping(value={""})
    public ResponseEntity<List<APIToken>> apiTokensByInstitution(@Parameter(hidden=true) User user) {
        LOG.debug((Object)"/tokens");
        UserPermissions.assertInstitutionAdmin((User)user);
        return ResponseEntity.ok((Object)this.apiTokenRepository.findByOrganizationGUID(user.getOrganizationGUID()));
    }

    @GetMapping(value={"generate-token"})
    public ResponseEntity<Map<String, String>> generateToken(@Parameter(hidden=true) User user, @Parameter(hidden=true) HttpServletRequest request) {
        LOG.debug((Object)"/generateToken");
        UserPermissions.assertInstitutionAdmin((User)user);
        String token = HashGenerator.generateToken();
        request.getSession().setAttribute(TOKEN_KEY, (Object)token);
        return ResponseEntity.ok(Map.of("token", token));
    }

    @PostMapping(value={""})
    public ResponseEntity<APIToken> create(@Validated @RequestBody APIToken apiTokenRequest, @Parameter(hidden=true) User user, @Parameter(hidden=true) HttpServletRequest request) {
        LOG.debug((Object)"/create");
        UserPermissions.assertInstitutionAdmin((User)user);
        String token = (String)request.getSession().getAttribute(TOKEN_KEY);
        if (!StringUtils.hasText((String)token)) {
            throw new UserRestrictionException();
        }
        APIToken apiToken = new APIToken(user.getOrganizationGUID(), HashGenerator.hashToken((String)token), apiTokenRequest.getDescription());
        return ResponseEntity.ok((Object)((APIToken)this.apiTokenRepository.save((Object)apiToken)));
    }

    @DeleteMapping(value={"/{id}"})
    public ResponseEntity<Void> deleteToken(@PathVariable(value="id") Long id, @Parameter(hidden=true) User user) {
        LOG.debug((Object)"/deleteToken");
        UserPermissions.assertInstitutionAdmin((User)user);
        APIToken apiToken = (APIToken)this.apiTokenRepository.findById((Object)id).orElseThrow(NotFoundException::new);
        if (!apiToken.getOrganizationGUID().equals(user.getOrganizationGUID())) {
            throw new UserRestrictionException();
        }
        this.apiTokenRepository.delete((Object)apiToken);
        return Results.deleteResult();
    }
}

