/*
 * Decompiled with CFR 0.152.
 */
package access.api;

import access.api.Results;
import access.config.Config;
import access.exception.NotAllowedException;
import access.exception.NotFoundException;
import access.logging.AccessLogger;
import access.logging.Event;
import access.model.Authority;
import access.model.Role;
import access.model.UpdateUserRole;
import access.model.User;
import access.model.UserRole;
import access.model.UserRoleProvisioning;
import access.provision.ProvisioningService;
import access.provision.scim.OperationType;
import access.repository.RoleRepository;
import access.repository.UserRepository;
import access.repository.UserRoleRepository;
import access.security.UserPermissions;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import io.swagger.v3.oas.annotations.security.SecurityRequirements;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.http.ResponseEntity;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/v1/user_roles", "/api/external/v1/user_roles"}, produces={"application/json"})
@Transactional
@SecurityRequirements(value={@SecurityRequirement(name="openId", scopes={"openid"}), @SecurityRequirement(name="apiTokens")})
@EnableConfigurationProperties(value={Config.class})
public class UserRoleController {
    private static final Log LOG = LogFactory.getLog(UserRoleController.class);
    private final UserRoleRepository userRoleRepository;
    private final RoleRepository roleRepository;
    private final UserRepository userRepository;
    private final ProvisioningService provisioningService;
    private final Config config;

    public UserRoleController(UserRoleRepository userRoleRepository, RoleRepository roleRepository, UserRepository userRepository, ProvisioningService provisioningService, Config config) {
        this.userRoleRepository = userRoleRepository;
        this.roleRepository = roleRepository;
        this.userRepository = userRepository;
        this.provisioningService = provisioningService;
        this.config = config;
    }

    @GetMapping(value={"roles/{roleId}"})
    public ResponseEntity<List<UserRole>> byRole(@PathVariable(value="roleId") Long roleId, @Parameter(hidden=true) User user) {
        LOG.debug((Object)"/me");
        Role role = (Role)this.roleRepository.findById((Object)roleId).orElseThrow(NotFoundException::new);
        UserPermissions.assertRoleAccess((User)user, (Role)role, (Authority)Authority.INVITER);
        List userRoles = this.userRoleRepository.findByRole(role);
        userRoles.forEach(userRole -> userRole.setUserInfo(userRole.getUser().asMap()));
        return ResponseEntity.ok((Object)userRoles);
    }

    @PostMapping(value={"user_role_provisioning"})
    @Operation(summary="Add Role to a User", description="Provision the User if the User is unknown and add the Role(s)")
    public ResponseEntity<User> userRoleProvisioning(@Validated @RequestBody UserRoleProvisioning userRoleProvisioning, @Parameter(hidden=true) User apiUser) {
        userRoleProvisioning.validate();
        UserPermissions.assertInstitutionAdmin((User)apiUser);
        List<Role> roles = userRoleProvisioning.roleIdentifiers.stream().map(roleId -> (Role)this.roleRepository.findById(roleId).orElseThrow(NotFoundException::new)).toList();
        UserPermissions.assertValidInvitation((User)apiUser, (Authority)userRoleProvisioning.intendedAuthority, roles);
        Optional userOptional = Optional.empty();
        if (StringUtils.hasText((String)userRoleProvisioning.sub)) {
            userOptional = this.userRepository.findBySubIgnoreCase(userRoleProvisioning.sub);
        } else if (StringUtils.hasText((String)userRoleProvisioning.eduPersonPrincipalName)) {
            userOptional = this.userRepository.findByEduPersonPrincipalNameIgnoreCase(userRoleProvisioning.eduPersonPrincipalName);
        } else if (StringUtils.hasText((String)userRoleProvisioning.email)) {
            userOptional = this.userRepository.findByEmailIgnoreCase(userRoleProvisioning.email);
        }
        User user = userOptional.orElseGet(() -> (User)this.userRepository.save((Object)new User(userRoleProvisioning)));
        List<UserRole> newUserRoles = roles.stream().map(role -> user.getUserRoles().stream().noneMatch(userRole -> userRole.getRole().getId().equals(role.getId())) ? user.addUserRole(new UserRole(apiUser.getName(), user, role, userRoleProvisioning.intendedAuthority, userRoleProvisioning.guestRoleIncluded, Instant.now().plus((long)role.getDefaultExpiryDays().intValue(), ChronoUnit.DAYS))) : null).filter(Objects::nonNull).toList();
        this.userRepository.save((Object)user);
        AccessLogger.user((Log)LOG, (Event)Event.Created, (User)user);
        this.provisioningService.newUserRequest(user);
        newUserRoles.forEach(userRole -> this.provisioningService.updateGroupRequest(userRole, OperationType.Add));
        return ResponseEntity.status((int)201).body((Object)user);
    }

    @PutMapping(value={""})
    public ResponseEntity<Map<String, Integer>> updateUserRoleExpirationDate(@Validated @RequestBody UpdateUserRole updateUserRole, @Parameter(hidden=true) User user) {
        UserRole userRole = (UserRole)this.userRoleRepository.findById((Object)updateUserRole.getUserRoleId()).orElseThrow(NotFoundException::new);
        if (updateUserRole.getEndDate() != null && !this.config.isPastDateAllowed() && Instant.now().isAfter(updateUserRole.getEndDate())) {
            throw new NotAllowedException("End date must be after now");
        }
        UserPermissions.assertValidInvitation((User)user, (Authority)userRole.getAuthority(), List.of(userRole.getRole()));
        userRole.setEndDate(updateUserRole.getEndDate());
        this.userRoleRepository.save((Object)userRole);
        return Results.createResult();
    }

    @DeleteMapping(value={"/{id}"})
    public ResponseEntity<Void> deleteUserRole(@PathVariable(value="id") Long id, @Parameter(hidden=true) User user) {
        LOG.debug((Object)"/deleteUserRole");
        UserRole userRole = (UserRole)this.userRoleRepository.findById((Object)id).orElseThrow(NotFoundException::new);
        UserPermissions.assertValidInvitation((User)user, (Authority)userRole.getAuthority(), List.of(userRole.getRole()));
        this.provisioningService.updateGroupRequest(userRole, OperationType.Remove);
        this.userRoleRepository.deleteUserRoleById(id);
        AccessLogger.userRole((Log)LOG, (Event)Event.Deleted, (User)user, (UserRole)userRole);
        return Results.deleteResult();
    }
}

