/*
 * Decompiled with CFR 0.152.
 */
package access.model;

import access.model.Authority;
import access.model.InvitationRole;
import access.model.Language;
import access.model.Status;
import access.model.User;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.FetchType;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.OneToMany;
import jakarta.persistence.Transient;
import jakarta.validation.constraints.NotEmpty;
import java.io.Serializable;
import java.time.Instant;
import java.time.Period;
import java.time.temporal.ChronoUnit;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Entity(name="invitations")
public class Invitation
implements Serializable {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private Long id;
    @Enumerated(value=EnumType.STRING)
    @Column(name="intended_authority")
    private Authority intendedAuthority;
    @Enumerated(value=EnumType.STRING)
    private Language language;
    @Enumerated(value=EnumType.STRING)
    private Status status;
    @Column
    private String email;
    @Column
    private String message;
    @Column
    @JsonProperty(access=JsonProperty.Access.WRITE_ONLY)
    private String hash;
    @Column(name="sub_invitee")
    private String subInvitee;
    @Column(name="enforce_email_equality")
    private boolean enforceEmailEquality;
    @Column(name="edu_id_only")
    private boolean eduIDOnly;
    @Column(name="guest_role_included")
    private boolean guestRoleIncluded;
    @Column(name="created_at")
    private Instant createdAt;
    @Column(name="expiry_date")
    private Instant expiryDate;
    @Column(name="role_expiry_date")
    private Instant roleExpiryDate;
    @ManyToOne(fetch=FetchType.EAGER)
    @JoinColumn(name="inviter_id")
    @JsonIgnore
    private User inviter;
    @OneToMany(mappedBy="invitation", orphanRemoval=true, fetch=FetchType.EAGER, cascade={CascadeType.ALL})
    private Set<InvitationRole> roles = new HashSet();
    @Transient
    private boolean emailEqualityConflict = false;

    public Invitation(Authority intendedAuthority, String hash, String email, boolean enforceEmailEquality, boolean eduIDOnly, boolean guestRoleIncluded, String message, Language language, User inviter, Instant expiryDate, Instant roleExpiryDate, @NotEmpty Set<InvitationRole> roles) {
        this.intendedAuthority = intendedAuthority;
        this.hash = hash;
        this.enforceEmailEquality = enforceEmailEquality;
        this.eduIDOnly = eduIDOnly;
        this.guestRoleIncluded = guestRoleIncluded;
        this.message = message;
        this.inviter = inviter;
        this.status = Status.OPEN;
        this.roles = roles;
        this.email = email;
        this.expiryDate = expiryDate == null ? Instant.now().plus(Period.ofDays(14)) : expiryDate;
        this.roleExpiryDate = this.roleExpiryDate(roles, roleExpiryDate, intendedAuthority);
        this.createdAt = Instant.now();
        roles.forEach(role -> role.setInvitation(this));
        this.language = language;
    }

    private Instant roleExpiryDate(@NotEmpty Set<InvitationRole> roles, Instant roleExpiryDate, Authority intendedAuthority) {
        if (roleExpiryDate != null || !intendedAuthority.equals((Object)Authority.GUEST)) {
            return roleExpiryDate;
        }
        Integer days = roles.stream().map(invitationRole -> invitationRole.getRole().getDefaultExpiryDays()).filter(Objects::nonNull).min(Comparator.naturalOrder()).orElse(365);
        return Instant.now().plus((long)days.intValue(), ChronoUnit.DAYS);
    }

    @JsonIgnore
    public List<String> anyRoles() {
        return CollectionUtils.isEmpty((Collection)this.roles) ? Collections.emptyList() : Arrays.asList("will-iterate-once");
    }

    @JsonProperty(value="inviter", access=JsonProperty.Access.READ_ONLY)
    public Map<String, String> getInviterEmail() {
        User inviter = this.getInviter();
        return inviter != null ? Map.of("email", inviter.getEmail(), "name", StringUtils.hasText((String)inviter.getName()) ? inviter.getName() : inviter.getEmail()) : Collections.emptyMap();
    }

    public Invitation() {
    }

    public Long getId() {
        return this.id;
    }

    public Authority getIntendedAuthority() {
        return this.intendedAuthority;
    }

    public Language getLanguage() {
        return this.language;
    }

    public Status getStatus() {
        return this.status;
    }

    public String getEmail() {
        return this.email;
    }

    public String getMessage() {
        return this.message;
    }

    public String getHash() {
        return this.hash;
    }

    public String getSubInvitee() {
        return this.subInvitee;
    }

    public boolean isEnforceEmailEquality() {
        return this.enforceEmailEquality;
    }

    public boolean isEduIDOnly() {
        return this.eduIDOnly;
    }

    public boolean isGuestRoleIncluded() {
        return this.guestRoleIncluded;
    }

    public Instant getCreatedAt() {
        return this.createdAt;
    }

    public Instant getExpiryDate() {
        return this.expiryDate;
    }

    public Instant getRoleExpiryDate() {
        return this.roleExpiryDate;
    }

    public User getInviter() {
        return this.inviter;
    }

    public Set<InvitationRole> getRoles() {
        return this.roles;
    }

    public boolean isEmailEqualityConflict() {
        return this.emailEqualityConflict;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setIntendedAuthority(Authority intendedAuthority) {
        this.intendedAuthority = intendedAuthority;
    }

    public void setLanguage(Language language) {
        this.language = language;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    @JsonProperty(access=JsonProperty.Access.WRITE_ONLY)
    public void setHash(String hash) {
        this.hash = hash;
    }

    public void setSubInvitee(String subInvitee) {
        this.subInvitee = subInvitee;
    }

    public void setEnforceEmailEquality(boolean enforceEmailEquality) {
        this.enforceEmailEquality = enforceEmailEquality;
    }

    public void setEduIDOnly(boolean eduIDOnly) {
        this.eduIDOnly = eduIDOnly;
    }

    public void setGuestRoleIncluded(boolean guestRoleIncluded) {
        this.guestRoleIncluded = guestRoleIncluded;
    }

    public void setCreatedAt(Instant createdAt) {
        this.createdAt = createdAt;
    }

    public void setExpiryDate(Instant expiryDate) {
        this.expiryDate = expiryDate;
    }

    public void setRoleExpiryDate(Instant roleExpiryDate) {
        this.roleExpiryDate = roleExpiryDate;
    }

    @JsonIgnore
    public void setInviter(User inviter) {
        this.inviter = inviter;
    }

    public void setRoles(Set<InvitationRole> roles) {
        this.roles = roles;
    }

    public void setEmailEqualityConflict(boolean emailEqualityConflict) {
        this.emailEqualityConflict = emailEqualityConflict;
    }
}

