/*
 * Decompiled with CFR 0.152.
 */
package access.provision;

import access.provision.Provisioning;
import access.provision.ProvisioningType;
import java.util.Map;

public class Provisioning {
    private final String id;
    private final String entityId;
    private final ProvisioningType provisioningType;
    private final String scimUrl;
    private final String scimUser;
    private final String scimPassword;
    private final String evaToken;
    private final boolean scimUpdateRolePutMethod;
    private final String evaUrl;
    private final int evaGuestAccountDuration;
    private final String graphUrl;
    private final String graphClientId;
    private final String graphSecret;
    private final String graphTenant;

    public Provisioning(Map<String, Object> provider) {
        this.id = (String)provider.get("id");
        this.entityId = (String)provider.get("entityid");
        this.provisioningType = ProvisioningType.valueOf((String)((String)provider.get("provisioning_type")));
        this.scimUrl = (String)provider.get("scim_url");
        this.scimUser = (String)provider.get("scim_user");
        this.scimPassword = (String)provider.get("scim_password");
        Object updateRolePutMethod = provider.get("scim_update_role_put_method");
        this.scimUpdateRolePutMethod = updateRolePutMethod != null && (Boolean)updateRolePutMethod != false;
        this.evaUrl = (String)provider.get("eva_url");
        this.evaToken = (String)provider.get("eva_token");
        Object guestAccountDuration = provider.get("eva_guest_account_duration");
        this.evaGuestAccountDuration = guestAccountDuration != null ? (Integer)guestAccountDuration : 30;
        this.graphUrl = (String)provider.get("graph_url");
        this.graphClientId = (String)provider.get("graph_client_id");
        this.graphSecret = (String)provider.get("graph_secret");
        this.graphTenant = (String)provider.getOrDefault("graph_tenant", "common");
        this.invariant();
    }

    private void invariant() {
        switch (1.$SwitchMap$access$provision$ProvisioningType[this.provisioningType.ordinal()]) {
            case 1: {
                assert (this.evaUrl != null) : "evaUrl is null";
                assert (this.evaToken != null) : "evaToken is null";
                break;
            }
            case 2: {
                assert (this.scimUrl != null) : "scimUrl is null";
                assert (this.scimUser != null) : "scimUser is null";
                assert (this.scimPassword != null) : "scimPassword is null";
                break;
            }
            case 3: {
                assert (this.graphClientId != null) : "graphClientId is null";
                assert (this.graphSecret != null) : "graphSecret is null";
                break;
            }
        }
    }

    public boolean isApplicableForGroupRequest() {
        return ProvisioningType.scim.equals((Object)this.provisioningType);
    }

    public String getId() {
        return this.id;
    }

    public String getEntityId() {
        return this.entityId;
    }

    public ProvisioningType getProvisioningType() {
        return this.provisioningType;
    }

    public String getScimUrl() {
        return this.scimUrl;
    }

    public String getScimUser() {
        return this.scimUser;
    }

    public String getScimPassword() {
        return this.scimPassword;
    }

    public String getEvaToken() {
        return this.evaToken;
    }

    public boolean isScimUpdateRolePutMethod() {
        return this.scimUpdateRolePutMethod;
    }

    public String getEvaUrl() {
        return this.evaUrl;
    }

    public int getEvaGuestAccountDuration() {
        return this.evaGuestAccountDuration;
    }

    public String getGraphUrl() {
        return this.graphUrl;
    }

    public String getGraphClientId() {
        return this.graphClientId;
    }

    public String getGraphSecret() {
        return this.graphSecret;
    }

    public String getGraphTenant() {
        return this.graphTenant;
    }
}

