/*
 * Decompiled with CFR 0.152.
 */
package access.api;

import access.api.Results;
import access.config.HashGenerator;
import access.exception.InvitationEmailMatchingException;
import access.exception.InvitationExpiredException;
import access.exception.InvitationStatusException;
import access.exception.NotAllowedException;
import access.exception.NotFoundException;
import access.logging.AccessLogger;
import access.logging.Event;
import access.mail.MailBox;
import access.manage.Manage;
import access.model.AcceptInvitation;
import access.model.Authority;
import access.model.Invitation;
import access.model.InvitationRequest;
import access.model.InvitationRole;
import access.model.Role;
import access.model.Status;
import access.model.User;
import access.model.UserRole;
import access.provision.ProvisioningService;
import access.provision.scim.OperationType;
import access.repository.InvitationRepository;
import access.repository.RoleRepository;
import access.repository.UserRepository;
import access.security.SuperAdmin;
import access.security.UserPermissions;
import access.validation.EmailFormatValidator;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import io.swagger.v3.oas.annotations.security.SecurityRequirements;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.time.Instant;
import java.time.Period;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.oauth2.client.authentication.OAuth2AuthenticationToken;
import org.springframework.security.oauth2.core.oidc.OidcUserInfo;
import org.springframework.security.oauth2.core.oidc.user.DefaultOidcUser;
import org.springframework.security.oauth2.core.user.OAuth2User;
import org.springframework.security.web.context.SecurityContextRepository;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/v1/invitations", "/api/external/v1/invitations"}, produces={"application/json"})
@Transactional
@SecurityRequirements(value={@SecurityRequirement(name="openId", scopes={"openid"}), @SecurityRequirement(name="apiTokens")})
@EnableConfigurationProperties(value={SuperAdmin.class})
public class InvitationController {
    private static final Log LOG = LogFactory.getLog(InvitationController.class);
    private final MailBox mailBox;
    private final Manage manage;
    private final InvitationRepository invitationRepository;
    private final UserRepository userRepository;
    private final RoleRepository roleRepository;
    private final ProvisioningService provisioningService;
    private final SecurityContextRepository securityContextRepository;
    private final SuperAdmin superAdmin;
    private final EmailFormatValidator emailFormatValidator = new EmailFormatValidator();

    public InvitationController(MailBox mailBox, Manage manage, InvitationRepository invitationRepository, UserRepository userRepository, RoleRepository roleRepository, ProvisioningService provisioningService, SecurityContextRepository securityContextRepository, SuperAdmin superAdmin) {
        this.mailBox = mailBox;
        this.manage = manage;
        this.invitationRepository = invitationRepository;
        this.userRepository = userRepository;
        this.roleRepository = roleRepository;
        this.provisioningService = provisioningService;
        this.securityContextRepository = securityContextRepository;
        this.superAdmin = superAdmin;
    }

    @PostMapping(value={""})
    public ResponseEntity<Map<String, Integer>> newInvitation(@Validated @RequestBody InvitationRequest invitationRequest, @Parameter(hidden=true) User user) {
        Authority intendedAuthority = invitationRequest.getIntendedAuthority();
        if (!List.of(Authority.INSTITUTION_ADMIN, Authority.SUPER_USER).contains(intendedAuthority) && CollectionUtils.isEmpty((Collection)invitationRequest.getRoleIdentifiers())) {
            throw new NotAllowedException("Invitation for non-super-user or institution-admin must contain at least one role");
        }
        List<Role> requestedRoles = invitationRequest.getRoleIdentifiers().stream().map(id -> (Role)this.roleRepository.findById(id).orElseThrow(NotFoundException::new)).toList();
        UserPermissions.assertValidInvitation((User)user, (Authority)intendedAuthority, requestedRoles);
        boolean isOverrideSettingsAllowed = requestedRoles.stream().allMatch(Role::isOverrideSettingsAllowed);
        if (!isOverrideSettingsAllowed) {
            invitationRequest.setEduIDOnly(requestedRoles.stream().anyMatch(Role::isEduIDOnly));
            invitationRequest.setEnforceEmailEquality(requestedRoles.stream().anyMatch(Role::isEnforceEmailEquality));
            if (intendedAuthority.equals((Object)Authority.GUEST)) {
                Integer defaultExpiryDays = requestedRoles.stream().max(Comparator.comparingInt(Role::getDefaultExpiryDays)).get().getDefaultExpiryDays();
                invitationRequest.setRoleExpiryDate(Instant.now().plus((long)defaultExpiryDays.intValue(), ChronoUnit.DAYS));
            }
        }
        List<Invitation> invitations = invitationRequest.getInvites().stream().filter(arg_0 -> ((EmailFormatValidator)this.emailFormatValidator).isValid(arg_0)).map(invitee -> new Invitation(intendedAuthority, HashGenerator.generateHash(), invitee, invitationRequest.isEnforceEmailEquality(), invitationRequest.isEduIDOnly(), invitationRequest.isGuestRoleIncluded(), invitationRequest.getMessage(), invitationRequest.getLanguage(), user, invitationRequest.getExpiryDate(), invitationRequest.getRoleExpiryDate(), requestedRoles.stream().map(InvitationRole::new).collect(Collectors.toSet()))).toList();
        this.invitationRepository.saveAll(invitations);
        List groupedProviders = this.manage.getGroupedProviders(requestedRoles);
        invitations.forEach(invitation -> this.mailBox.sendInviteMail(user, invitation, groupedProviders, invitationRequest.getLanguage()));
        invitations.forEach(invitation -> AccessLogger.invitation((Log)LOG, (Event)Event.Created, (Invitation)invitation));
        return Results.createResult();
    }

    @DeleteMapping(value={"/{id}"})
    public ResponseEntity<Void> deleteInvitation(@PathVariable(value="id") Long id, @Parameter(hidden=true) User user) {
        LOG.debug((Object)String.format("/deleteInvitation/%s by user %s", id, user.getEduPersonPrincipalName()));
        Invitation invitation = (Invitation)this.invitationRepository.findById((Object)id).orElseThrow(NotFoundException::new);
        List<Role> requestedRoles = invitation.getRoles().stream().map(InvitationRole::getRole).toList();
        Authority intendedAuthority = invitation.getIntendedAuthority();
        UserPermissions.assertValidInvitation((User)user, (Authority)intendedAuthority, requestedRoles);
        AccessLogger.invitation((Log)LOG, (Event)Event.Deleted, (Invitation)invitation);
        this.invitationRepository.delete((Object)invitation);
        return Results.deleteResult();
    }

    @PutMapping(value={"/{id}"})
    public ResponseEntity<Map<String, Integer>> resendInvitation(@PathVariable(value="id") Long id, @Parameter(hidden=true) User user) {
        LOG.debug((Object)String.format("/resendInvitation/%s by user %s", id, user.getEduPersonPrincipalName()));
        Invitation invitation = (Invitation)this.invitationRepository.findById((Object)id).orElseThrow(NotFoundException::new);
        List<Role> requestedRoles = invitation.getRoles().stream().map(InvitationRole::getRole).toList();
        Authority intendedAuthority = invitation.getIntendedAuthority();
        UserPermissions.assertValidInvitation((User)user, (Authority)intendedAuthority, requestedRoles);
        List groupedProviders = this.manage.getGroupedProviders(requestedRoles);
        this.mailBox.sendInviteMail(user, invitation, groupedProviders, invitation.getLanguage());
        if (invitation.getExpiryDate().isBefore(Instant.now())) {
            invitation.setExpiryDate(Instant.now().plus(Period.ofDays(14)));
            this.invitationRepository.save((Object)invitation);
        }
        AccessLogger.invitation((Log)LOG, (Event)Event.Resend, (Invitation)invitation);
        return Results.createResult();
    }

    @GetMapping(value={"public"})
    public ResponseEntity<Invitation> getInvitation(@RequestParam(value="hash") String hash) {
        Invitation invitation = (Invitation)this.invitationRepository.findByHash(hash).orElseThrow(NotFoundException::new);
        if (!invitation.getStatus().equals((Object)Status.OPEN)) {
            throw new InvitationStatusException("Invitation is not OPEN anymore");
        }
        this.manage.addManageMetaData(invitation.getRoles().stream().map(InvitationRole::getRole).toList());
        return ResponseEntity.ok((Object)invitation);
    }

    @GetMapping(value={"all"})
    public ResponseEntity<List<Invitation>> all(@Parameter(hidden=true) User user) {
        LOG.debug((Object)"/all invitations");
        UserPermissions.assertAuthority((User)user, (Authority)Authority.INVITER);
        if (user.isSuperUser()) {
            return ResponseEntity.ok((Object)this.invitationRepository.findAll());
        }
        List<Role> roles = user.getUserRoles().stream().map(UserRole::getRole).toList();
        return ResponseEntity.ok((Object)this.invitationRepository.findByRoles_roleIsIn(roles));
    }

    @PostMapping(value={"accept"})
    public ResponseEntity<Map<String, ? extends Serializable>> accept(@Validated @RequestBody AcceptInvitation acceptInvitation, Authentication authentication, HttpServletRequest servletRequest, HttpServletResponse servletResponse) {
        Invitation invitation = (Invitation)this.invitationRepository.findByHash(acceptInvitation.hash()).orElseThrow(NotFoundException::new);
        if (!invitation.getId().equals(acceptInvitation.invitationId())) {
            throw new NotFoundException();
        }
        if (!invitation.getStatus().equals((Object)Status.OPEN)) {
            throw new InvitationStatusException("Invitation is not OPEN anymore");
        }
        if (invitation.getExpiryDate().isBefore(Instant.now())) {
            throw new InvitationExpiredException("Invitation has expired");
        }
        OAuth2AuthenticationToken token = (OAuth2AuthenticationToken)authentication;
        Map attributes = token.getPrincipal().getAttributes();
        String sub = (String)attributes.get("sub");
        Optional optionalUser = this.userRepository.findBySubIgnoreCase(sub);
        Authority intendedAuthority = invitation.getIntendedAuthority();
        User user = optionalUser.orElseGet(() -> {
            boolean superUser = this.superAdmin.getUsers().stream().anyMatch(superSub -> superSub.equals(sub)) || intendedAuthority.equals((Object)Authority.SUPER_USER);
            return new User(superUser, attributes);
        });
        this.checkEmailEquality(user, invitation);
        user.setLastActivity(Instant.now());
        invitation.setStatus(Status.ACCEPTED);
        invitation.setSubInvitee(sub);
        this.invitationRepository.save((Object)invitation);
        AccessLogger.invitation((Log)LOG, (Event)Event.Accepted, (Invitation)invitation);
        ArrayList newUserRoles = new ArrayList();
        User inviter = invitation.getInviter();
        invitation.getRoles().forEach(invitationRole -> {
            Role role = invitationRole.getRole();
            Optional<UserRole> optionalUserRole = user.getUserRoles().stream().filter(userRole -> userRole.getRole().getId().equals(role.getId())).findFirst();
            if (optionalUserRole.isPresent()) {
                UserRole userRole2 = optionalUserRole.get();
                Authority currentAuthority = userRole2.getAuthority();
                if (!currentAuthority.equals((Object)intendedAuthority)) {
                    if (intendedAuthority.hasHigherRights(currentAuthority)) {
                        userRole2.setAuthority(intendedAuthority);
                        userRole2.setEndDate(invitation.getRoleExpiryDate());
                    }
                    if (currentAuthority.equals((Object)Authority.GUEST) || intendedAuthority.equals((Object)Authority.GUEST) || invitation.isGuestRoleIncluded()) {
                        userRole2.setGuestRoleIncluded(true);
                    }
                }
            } else {
                UserRole userRole3 = new UserRole(inviter.getName(), user, role, intendedAuthority, invitation.isGuestRoleIncluded(), invitation.getRoleExpiryDate());
                user.addUserRole(userRole3);
                newUserRoles.add(userRole3);
            }
        });
        if (intendedAuthority.equals((Object)Authority.INSTITUTION_ADMIN)) {
            user.setInstitutionAdmin(true);
            user.setInstitutionAdminByInvite(true);
            user.setOrganizationGUID(inviter.getOrganizationGUID());
            if (optionalUser.isEmpty()) {
                this.saveOAuth2AuthenticationToken(authentication, user, servletRequest, servletResponse);
            }
        }
        this.userRepository.save((Object)user);
        AccessLogger.user((Log)LOG, (Event)Event.Created, (User)user);
        Optional graphResponse = this.provisioningService.newUserRequest(user);
        newUserRoles.forEach(userRole -> this.provisioningService.updateGroupRequest(userRole, OperationType.Add));
        LOG.info((Object)String.format("User %s accepted invitation with role(s) %s", user.getEduPersonPrincipalName(), invitation.getRoles().stream().map(role -> role.getRole().getName()).collect(Collectors.joining(", "))));
        Map<String, String> body = graphResponse.map(graph -> graph.isErrorResponse() ? Map.of("errorResponse", Boolean.TRUE) : Map.of("inviteRedeemUrl", graph.inviteRedeemUrl())).orElse(Map.of("status", "ok"));
        return ResponseEntity.status((HttpStatusCode)HttpStatus.CREATED).body(body);
    }

    private void saveOAuth2AuthenticationToken(Authentication authentication, User user, HttpServletRequest servletRequest, HttpServletResponse servletResponse) {
        OAuth2AuthenticationToken existingToken = (OAuth2AuthenticationToken)authentication;
        DefaultOidcUser existingTokenPrincipal = (DefaultOidcUser)existingToken.getPrincipal();
        HashMap claims = new HashMap(existingTokenPrincipal.getClaims());
        claims.putAll(this.manage.enrichInstitutionAdmin(user.getOrganizationGUID()));
        DefaultOidcUser oidcUser = new DefaultOidcUser(existingToken.getAuthorities(), existingTokenPrincipal.getIdToken(), new OidcUserInfo(claims));
        OAuth2AuthenticationToken newToken = new OAuth2AuthenticationToken((OAuth2User)oidcUser, existingToken.getAuthorities(), existingToken.getAuthorizedClientRegistrationId());
        SecurityContextHolder.getContext().setAuthentication((Authentication)newToken);
        this.securityContextRepository.saveContext(SecurityContextHolder.getContext(), servletRequest, servletResponse);
    }

    @GetMapping(value={"roles/{roleId}"})
    public ResponseEntity<List<Invitation>> byRole(@PathVariable(value="roleId") Long roleId, @Parameter(hidden=true) User user) {
        LOG.debug((Object)String.format("/roles/%s by user %s", roleId, user.getEduPersonPrincipalName()));
        Role role = (Role)this.roleRepository.findById((Object)roleId).orElseThrow(NotFoundException::new);
        UserPermissions.assertRoleAccess((User)user, (Role)role, (Authority)Authority.INVITER);
        List invitations = this.invitationRepository.findByStatusAndRoles_role(Status.OPEN, role);
        return ResponseEntity.ok((Object)invitations);
    }

    private void checkEmailEquality(User user, Invitation invitation) {
        if (invitation.isEnforceEmailEquality() && !invitation.getEmail().equalsIgnoreCase(user.getEmail())) {
            throw new InvitationEmailMatchingException(String.format("Invitation email %s does not match user email %s", invitation.getEmail(), user.getEmail()));
        }
    }
}

