/*
 * Decompiled with CFR 0.152.
 */
package access.config;

import java.util.List;
import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(prefix="config")
public class Config {
    private String clientUrl;
    private String welcomeUrl;
    private String serverUrl;
    private String serverWelcomeUrl;
    private String eduidEntityId;
    private boolean roleSearchRequired;
    private boolean pastDateAllowed;
    private String groupUrnPrefix;
    private boolean authenticated;
    private String name;
    private String eduidIdpSchacHomeOrganization;
    private List<String> missingAttributes;

    public Config(Config base) {
        this.clientUrl = base.clientUrl;
        this.welcomeUrl = base.welcomeUrl;
        this.serverUrl = base.serverUrl;
        this.serverWelcomeUrl = base.serverWelcomeUrl;
        this.eduidEntityId = base.eduidEntityId;
        this.pastDateAllowed = base.pastDateAllowed;
        this.roleSearchRequired = base.roleSearchRequired;
        this.groupUrnPrefix = base.groupUrnPrefix;
        this.eduidIdpSchacHomeOrganization = base.eduidIdpSchacHomeOrganization;
    }

    public Config withAuthenticated(boolean authenticated) {
        this.setAuthenticated(authenticated);
        return this;
    }

    public Config withName(String name) {
        this.setName(name);
        return this;
    }

    public Config withMissingAttributes(List<String> missingAttributes) {
        this.setMissingAttributes(missingAttributes);
        return this;
    }

    public Config withGroupUrnPrefix(String groupUrnPrefix) {
        this.setGroupUrnPrefix(groupUrnPrefix);
        return this;
    }

    public String getClientUrl() {
        return this.clientUrl;
    }

    public String getWelcomeUrl() {
        return this.welcomeUrl;
    }

    public String getServerUrl() {
        return this.serverUrl;
    }

    public String getServerWelcomeUrl() {
        return this.serverWelcomeUrl;
    }

    public String getEduidEntityId() {
        return this.eduidEntityId;
    }

    public boolean isRoleSearchRequired() {
        return this.roleSearchRequired;
    }

    public boolean isPastDateAllowed() {
        return this.pastDateAllowed;
    }

    public String getGroupUrnPrefix() {
        return this.groupUrnPrefix;
    }

    public boolean isAuthenticated() {
        return this.authenticated;
    }

    public String getName() {
        return this.name;
    }

    public String getEduidIdpSchacHomeOrganization() {
        return this.eduidIdpSchacHomeOrganization;
    }

    public List<String> getMissingAttributes() {
        return this.missingAttributes;
    }

    public void setClientUrl(String clientUrl) {
        this.clientUrl = clientUrl;
    }

    public void setWelcomeUrl(String welcomeUrl) {
        this.welcomeUrl = welcomeUrl;
    }

    public void setServerUrl(String serverUrl) {
        this.serverUrl = serverUrl;
    }

    public void setServerWelcomeUrl(String serverWelcomeUrl) {
        this.serverWelcomeUrl = serverWelcomeUrl;
    }

    public void setEduidEntityId(String eduidEntityId) {
        this.eduidEntityId = eduidEntityId;
    }

    public void setRoleSearchRequired(boolean roleSearchRequired) {
        this.roleSearchRequired = roleSearchRequired;
    }

    public void setPastDateAllowed(boolean pastDateAllowed) {
        this.pastDateAllowed = pastDateAllowed;
    }

    public void setGroupUrnPrefix(String groupUrnPrefix) {
        this.groupUrnPrefix = groupUrnPrefix;
    }

    public void setAuthenticated(boolean authenticated) {
        this.authenticated = authenticated;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setEduidIdpSchacHomeOrganization(String eduidIdpSchacHomeOrganization) {
        this.eduidIdpSchacHomeOrganization = eduidIdpSchacHomeOrganization;
    }

    public void setMissingAttributes(List<String> missingAttributes) {
        this.missingAttributes = missingAttributes;
    }

    public Config() {
    }
}

