/*
 * Decompiled with CFR 0.152.
 */
package access.model;

import access.model.Application;
import access.model.ApplicationUsage;
import access.model.Auditable;
import access.model.Provisionable;
import access.provision.scim.GroupURN;
import com.fasterxml.jackson.annotation.JsonIgnore;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.Embedded;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.OneToMany;
import jakarta.persistence.Transient;
import jakarta.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.hibernate.annotations.Formula;

@Entity(name="roles")
public class Role
implements Serializable,
Provisionable {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private Long id;
    @Column
    @NotNull
    private String name;
    @Column(name="short_name")
    @NotNull
    private String shortName;
    @Column(name="description")
    private String description;
    @Column(name="urn")
    private String urn;
    @Column(name="default_expiry_days")
    private Integer defaultExpiryDays;
    @Column(name="enforce_email_equality")
    private boolean enforceEmailEquality;
    @Column(name="edu_id_only")
    private boolean eduIDOnly;
    @Column(name="block_expiry_date")
    private boolean blockExpiryDate;
    @Column(name="override_settings_allowed")
    private boolean overrideSettingsAllowed;
    @Column(name="teams_origin")
    private boolean teamsOrigin;
    @Column(name="identifier")
    private String identifier;
    @Formula(value="(SELECT COUNT(*) FROM user_roles ur WHERE ur.role_id=id)")
    private Long userRoleCount;
    @OneToMany(mappedBy="role", fetch=FetchType.EAGER, orphanRemoval=true, cascade={CascadeType.ALL})
    private Set<ApplicationUsage> applicationUsages = new HashSet();
    @Embedded
    private Auditable auditable = new Auditable();
    @Transient
    private List<Map<String, Object>> applicationMaps;

    public Role(String name, String description, Set<ApplicationUsage> applicationUsages, Integer defaultExpiryDays, boolean enforceEmailEquality, boolean eduIDOnly) {
        this(name, GroupURN.sanitizeRoleShortName((String)name), description, applicationUsages, defaultExpiryDays, enforceEmailEquality, eduIDOnly, Collections.emptyList());
    }

    public Role(@NotNull String name, @NotNull String shortName, String description, Set<ApplicationUsage> applicationUsages, Integer defaultExpiryDays, boolean enforceEmailEquality, boolean eduIDOnly, List<Map<String, Object>> applicationMaps) {
        this.name = name;
        this.shortName = shortName;
        this.description = description;
        this.defaultExpiryDays = defaultExpiryDays;
        this.enforceEmailEquality = enforceEmailEquality;
        this.eduIDOnly = eduIDOnly;
        this.applicationUsages = applicationUsages;
        this.applicationUsages.forEach(applicationUsage -> applicationUsage.setRole(this));
        this.applicationMaps = applicationMaps;
        this.identifier = UUID.randomUUID().toString();
    }

    @Transient
    @JsonIgnore
    public List<String> applicationIdentifiers() {
        return this.applicationUsages.stream().map(applicationUsage -> applicationUsage.getApplication().getManageId()).toList();
    }

    @Transient
    @JsonIgnore
    public Set<Application> applicationsUsed() {
        return this.applicationUsages.stream().map(ApplicationUsage::getApplication).collect(Collectors.toSet());
    }

    public void setApplicationUsages(Set<ApplicationUsage> applicationUsages) {
        this.applicationUsages = applicationUsages;
        this.applicationUsages.forEach(applicationUsage -> applicationUsage.setRole(this));
    }

    public Role() {
    }

    public Long getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getShortName() {
        return this.shortName;
    }

    public String getDescription() {
        return this.description;
    }

    public String getUrn() {
        return this.urn;
    }

    public Integer getDefaultExpiryDays() {
        return this.defaultExpiryDays;
    }

    public boolean isEnforceEmailEquality() {
        return this.enforceEmailEquality;
    }

    public boolean isEduIDOnly() {
        return this.eduIDOnly;
    }

    public boolean isBlockExpiryDate() {
        return this.blockExpiryDate;
    }

    public boolean isOverrideSettingsAllowed() {
        return this.overrideSettingsAllowed;
    }

    public boolean isTeamsOrigin() {
        return this.teamsOrigin;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public Long getUserRoleCount() {
        return this.userRoleCount;
    }

    public Set<ApplicationUsage> getApplicationUsages() {
        return this.applicationUsages;
    }

    public Auditable getAuditable() {
        return this.auditable;
    }

    public List<Map<String, Object>> getApplicationMaps() {
        return this.applicationMaps;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setShortName(String shortName) {
        this.shortName = shortName;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setUrn(String urn) {
        this.urn = urn;
    }

    public void setDefaultExpiryDays(Integer defaultExpiryDays) {
        this.defaultExpiryDays = defaultExpiryDays;
    }

    public void setEnforceEmailEquality(boolean enforceEmailEquality) {
        this.enforceEmailEquality = enforceEmailEquality;
    }

    public void setEduIDOnly(boolean eduIDOnly) {
        this.eduIDOnly = eduIDOnly;
    }

    public void setBlockExpiryDate(boolean blockExpiryDate) {
        this.blockExpiryDate = blockExpiryDate;
    }

    public void setOverrideSettingsAllowed(boolean overrideSettingsAllowed) {
        this.overrideSettingsAllowed = overrideSettingsAllowed;
    }

    public void setTeamsOrigin(boolean teamsOrigin) {
        this.teamsOrigin = teamsOrigin;
    }

    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    public void setUserRoleCount(Long userRoleCount) {
        this.userRoleCount = userRoleCount;
    }

    public void setAuditable(Auditable auditable) {
        this.auditable = auditable;
    }

    public void setApplicationMaps(List<Map<String, Object>> applicationMaps) {
        this.applicationMaps = applicationMaps;
    }
}

