/*
 * Decompiled with CFR 0.152.
 */
package access.security;

import access.security.RemoteUser;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.core.userdetails.UsernameNotFoundException;

public class ExtendedInMemoryUserDetailsManager
implements UserDetailsService {
    private final Map<String, RemoteUser> users;

    public ExtendedInMemoryUserDetailsManager(List<RemoteUser> users) {
        users.forEach(arg_0 -> this.fixPassword(arg_0));
        this.users = users.stream().collect(Collectors.toMap(UserDetails::getUsername, Function.identity()));
    }

    private void fixPassword(RemoteUser remoteUser) {
        String noopPrefix;
        String password = remoteUser.getPassword();
        boolean hasNoopPrefix = password.startsWith(noopPrefix = "{noop}");
        if (!hasNoopPrefix) {
            remoteUser.setPassword(noopPrefix.concat(password));
        }
    }

    public UserDetails loadUserByUsername(String username) throws UsernameNotFoundException {
        RemoteUser remoteUser = (RemoteUser)this.users.get(username);
        return remoteUser != null ? new RemoteUser(remoteUser) : null;
    }
}

