/*
 * Decompiled with CFR 0.152.
 */
package access.security;

import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.security.core.CredentialsContainer;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.userdetails.UserDetails;

public class RemoteUser
implements UserDetails,
CredentialsContainer {
    private String username;
    private String password;
    private List<String> scopes;

    public RemoteUser(RemoteUser remoteUser) {
        this.username = remoteUser.username;
        this.password = remoteUser.password;
        this.scopes = remoteUser.scopes;
    }

    public Collection<? extends GrantedAuthority> getAuthorities() {
        return this.scopes.stream().map(scope -> new SimpleGrantedAuthority("ROLE_" + scope.toUpperCase())).collect(Collectors.toList());
    }

    public boolean isAccountNonExpired() {
        return true;
    }

    public boolean isAccountNonLocked() {
        return true;
    }

    public boolean isCredentialsNonExpired() {
        return true;
    }

    public boolean isEnabled() {
        return true;
    }

    public void eraseCredentials() {
        this.password = null;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public List<String> getScopes() {
        return this.scopes;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setScopes(List<String> scopes) {
        this.scopes = scopes;
    }

    public RemoteUser() {
    }
}

