/*
 * Decompiled with CFR 0.152.
 */
package access.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.validation.constraints.NotBlank;
import java.io.Serializable;
import java.time.Instant;

@Entity(name="api_tokens")
public class APIToken
implements Serializable {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private Long id;
    @Column(name="organization_guid")
    @JsonProperty(access=JsonProperty.Access.WRITE_ONLY)
    private String organizationGUID;
    @Column(name="hashed_value")
    @JsonProperty(access=JsonProperty.Access.WRITE_ONLY)
    private String hashedValue;
    @Column(name="super_user_token")
    private boolean superUserToken;
    @Column(name="description")
    @NotBlank
    private String description;
    @Column(name="created_at")
    private Instant createdAt;

    public APIToken(String organizationGUID, String hashedValue, boolean superUserToken, String description) {
        this.organizationGUID = organizationGUID;
        this.hashedValue = hashedValue;
        this.superUserToken = superUserToken;
        this.description = description;
        this.createdAt = Instant.now();
    }

    public APIToken() {
    }

    public Long getId() {
        return this.id;
    }

    public String getOrganizationGUID() {
        return this.organizationGUID;
    }

    public String getHashedValue() {
        return this.hashedValue;
    }

    public boolean isSuperUserToken() {
        return this.superUserToken;
    }

    public String getDescription() {
        return this.description;
    }

    public Instant getCreatedAt() {
        return this.createdAt;
    }

    public void setId(Long id) {
        this.id = id;
    }

    @JsonProperty(access=JsonProperty.Access.WRITE_ONLY)
    public void setOrganizationGUID(String organizationGUID) {
        this.organizationGUID = organizationGUID;
    }

    @JsonProperty(access=JsonProperty.Access.WRITE_ONLY)
    public void setHashedValue(String hashedValue) {
        this.hashedValue = hashedValue;
    }

    public void setSuperUserToken(boolean superUserToken) {
        this.superUserToken = superUserToken;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setCreatedAt(Instant createdAt) {
        this.createdAt = createdAt;
    }
}

